## init.tcl
##
## Scotty initialization file. At the end of this file, we source
## the file init.tcl in the site subdirectory of the scotty library 
## directory. This is the preferred way to do site specific 
## initializations because this will work even after updating scotty 
## sources.
##
## Copyright (c) 1994
##
## J. Schoenwaelder
## TU Braunschweig, Germany
## Institute for Operating Systems and Computer Networks
##
## Permission to use, copy, modify, and distribute this
## software and its documentation for any purpose and without
## fee is hereby granted, provided that this copyright
## notice appears in all copies.  The University of Braunschweig
## makes no representations about the suitability of this
## software for any purpose.  It is provided "as is" without
## express or implied warranty.

##
## The global variable scotty_mibs is used to hold a list of mibs that
## are auto-loaded by a scotty interpreter. You can extend or
## redefine this list in your site/init.tcl file, which gets 
## sourced at the end of this script.
##

lappend scotty_mibs $scotty_lib/mibs/rfc1271.mib
	
lappend scotty_mibs $scotty_lib/mibs/rfc1414.mib
lappend scotty_mibs $scotty_lib/mibs/rfc1447.mib
lappend scotty_mibs $scotty_lib/mibs/rfc1451.mib
lappend scotty_mibs $scotty_lib/mibs/rfc1493.mib

lappend scotty_mibs $scotty_lib/mibs/rfc1512.mib
lappend scotty_mibs $scotty_lib/mibs/rfc1513.mib 
lappend scotty_mibs $scotty_lib/mibs/rfc1514.mib
lappend scotty_mibs $scotty_lib/mibs/rfc1515.mib
lappend scotty_mibs $scotty_lib/mibs/rfc1516.mib
lappend scotty_mibs $scotty_lib/mibs/rfc1525.mib
lappend scotty_mibs $scotty_lib/mibs/rfc1565.mib
lappend scotty_mibs $scotty_lib/mibs/rfc1566.mib
lappend scotty_mibs $scotty_lib/mibs/rfc1567.mib
lappend scotty_mibs $scotty_lib/mibs/rfc1573.smi
lappend scotty_mibs $scotty_lib/mibs/rfc1573.mib

lappend scotty_mibs $scotty_lib/mibs/rfc1611.mib
lappend scotty_mibs $scotty_lib/mibs/rfc1612.mib
lappend scotty_mibs $scotty_lib/mibs/rfc1650.mib
lappend scotty_mibs $scotty_lib/mibs/rfc1658.mib
lappend scotty_mibs $scotty_lib/mibs/rfc1659.mib
lappend scotty_mibs $scotty_lib/mibs/rfc1660.mib
lappend scotty_mibs $scotty_lib/mibs/rfc1696.mib
lappend scotty_mibs $scotty_lib/mibs/rfc1697.mib

# Vendor MIB definitions

lappend scotty_mibs $scotty_lib/mibs/cisco.mib
lappend scotty_mibs $scotty_lib/mibs/hp-unix.mib
lappend scotty_mibs $scotty_lib/mibs/synoptics.mib
lappend scotty_mibs $scotty_lib/mibs/unix.mib

# Some local MIB fun for experimentation

lappend scotty_mibs $scotty_lib/mibs/tubs.mib
lappend scotty_mibs $scotty_lib/mibs/mlm.mib

##
## Redefine the mib command. This is a little bit of magic, but it
## makes sure that the mib definitions above get loaded by the first 
## mib command. However, we do not autoload all the mibs above if the
## first mib command is a load command. Instead, we expect that the
## application knows what it needs.
##

if {[info commands mib] == "mib"} {

    rename mib _mib

    proc mib {args} {

	global scotty_lib scotty_mibs

	# always load the .smi and .tc and MIB-II definitions

	_mib load $scotty_lib/mibs/rfc1155.smi
	_mib load $scotty_lib/mibs/rfc1442.smi
	_mib load $scotty_lib/mibs/rfc1443.tc
	_mib load $scotty_lib/mibs/rfc1450.mib
	_mib load $scotty_lib/mibs/rfc1213.mib

	rename mib ""
	rename _mib mib

	# don't autoload if the first command is mib load

	if {[lindex $args 0] == "load"} {
	    return [eval mib $args]
	}

	foreach mib $scotty_mibs {
	    mib load $mib
	}

	return [eval mib $args]
    }

}

##
## This nice procedure allows us to use static variables. It was
## posted on the net by Karl Lehenbauer. There was another one
## which does not pollute the name space, but it fails on proc
## names or variable names with spaces in it...
##

proc static {args} {
    set procName [lindex [info level [expr [info level]-1]] 0]
    foreach varName $args {
        uplevel 1 "upvar #0 {$procName:$varName} $varName"
    }
}

##
## Check for addinput, removeinput and after command. Will be
## removed once we have tk 4.0.
##

foreach cmd "after addinput removeinput" {
    if {[info commands $cmd] == ""} {
	puts stderr "Warning: Command \"$cmd\" missing!"
    }
}

##
## Allow for site specific initializations.
##

if [file exists $scotty_lib/site/init.tcl] {
    source $scotty_lib/site/init.tcl
}

