/*
	Schrodinger's Box Haven  code version -0.1 alpha
        Copyright (C) 1994, Gordon Chan

	You can do whatever ya want with this code as long as you leave this
        copyright & disclaimer intact.  You can hack it up all you want, etc...
        No guarantees.

	Send comments, flames, bug reports, etc ... to
		au233@freenet.carleton.ca  <---- (preferred address for now)
		gjc@achilles.net
		gchan@ccs.carleton.ca
*/


/* Here's the copyrights & disclaimers from the Opium Den and unixCB codes */

/* Opium Den */
/*
  val's haven code v -0.85

        Copyright (C) 1994 Joel Ward

        Warranty:
                Don't blame me for anything.

        You can do whatever the fuck you want with this code as long as you
don't remove this copyright/disclaimer notice.
*/

/* unixCB */
/*
  
  cbd.c
  
  "cbd.c" is the main code for the CB simulator.
  
  Copyright (c) 1992, Gary Grossman.  All rights reserved.
  Send comments and questions to: garyg@soda.berkeley.edu
  
  */

#include <string.h>

#include "linked_lists.h"
#include "user_input.h"
#include "main.h"
#include "who_finger_lists.h"
#include "handles_and_channels.h"
#include "misc_commands.h"
#include "toggle_comm.h"
#include "security.h"
#include "power.h"
#include "chat.h"


/* command parser */

void set_command(user, command, message_buffer, prompt_buffer)
  struct user *user;
  char command, *message_buffer, *prompt_buffer;	
{
  switch (command) {
  case 'n':
    toggle_user(user, Fcomm_line);
    strcpy(message_buffer, "What name would you like?\r\n");
    strcpy(prompt_buffer, "Name: ");
    user->linecharmax = NAMEMAX;
    clear_queue(user->input);
    user->present_comm = change_name;
    break;
  case 'q':
    toggle_user(user, Fcomm_line);
    strcpy(message_buffer, ">> Would you really like to quit??\r\n");
    strcpy(prompt_buffer, "(yes/no): ");
    clear_queue(user->input);
    user->present_comm = get_out;		
    break;		
  case 'p':
    toggle_user(user, Fcomm_line);
    toggle_user(user, Fmultiple_comm);
    strcpy(message_buffer, ">> Who would you like to send a private to?\r\n");
    strcpy(prompt_buffer, "Who: ");
    user->linecharmax = NAMEMAX;
    clear_queue(user->input);
    user->present_comm = handle_private;
    break;
  case 'y':
    toggle_user(user, Fcomm_line);
    strcpy(message_buffer, "Type out message you want to yell.\r\n");
    strcpy(prompt_buffer, "Message: ");
    clear_queue(user->input);
    user->present_comm = yell;
    break;
  case 'w':
    strcpy(message_buffer, "Who List.\r\n");
    *prompt_buffer = '\0';
    clear_queue(user->input);
    user->present_comm = who;
    break;
  case 'f':
    strcpy(message_buffer, "Users Typing.\r\n");
    *prompt_buffer = '\0';
    clear_queue(user->input);
    user->present_comm = finger;
    break;
  case 'd':
    toggle_user(user, Fcomm_line);
    strcpy(message_buffer, "What description would you like?\r\n");
    strcpy(prompt_buffer, "Description: ");
    user->linecharmax = DESCRIPTIONMAX;
    clear_queue(user->input);
    user->present_comm = change_description;
    break;
  case 'c':
    toggle_user(user, Fcomm_line);
    strcpy(message_buffer, ">> Which channel would you like to go to?\r\n");
    strcpy(prompt_buffer, "Channel: ");
    user->linecharmax = CHANNELMAX;
    clear_queue(user->input);
    user->present_comm = change_channel;
    break;
  case 'C':
    strcpy(message_buffer, "Channel List.\r\n");
    *prompt_buffer = '\0';
    clear_queue(user->input);
    user->present_comm = channel_list;
    break;		
  case 'l':
    *message_buffer = '\0';
    *prompt_buffer = '\0';
    clear_queue(user->input);
    user->present_comm = lock_channel;
    break; 
  case 'M':
    *message_buffer = '\0';
    *prompt_buffer = '\0';
    clear_queue(user->input);
    user->present_comm = toggle_monitor;
    break;
  case 'm':
    *message_buffer = '\0';
    *prompt_buffer = '\0';
    clear_queue(user->input);
    user->present_comm = toggle_mess;
    break;
  case 'h':
    *message_buffer = '\0';
    *prompt_buffer = '\0';
    clear_queue(user->input);
    user->present_comm = toggle_hush;
    break;		
  case 's':
    strcpy(message_buffer, "Personal Stats.\r\n");
    *prompt_buffer = '\0';
    clear_queue(user->input);
    user->present_comm = personal_stats;
    break;		
  case '?':
    strcpy(message_buffer, "Help File.\r\n");
    *prompt_buffer = '\0';
    user->present_comm = show_help;
    break;
  case 'T':
    clear_queue(user->input);
    user->present_comm = toggle_colour;
    if (is_user(user, Fcolour)) {
      *message_buffer = '\0';
      *prompt_buffer = '\0';
    } else {
      toggle_user(user, Fcomm_line);
      colour_menu(user, message_buffer);
      strcpy(prompt_buffer, "Colour: ");   
      user->linecharmax = 1;
    }
    break;		
  case 'g':
    toggle_user(user, Fcomm_line);
    strcpy(message_buffer, "Who are you gonna gag?\r\n");
    strcpy(prompt_buffer, "Who: ");
    user->linecharmax = NAMEMAX;
    clear_queue(user->input);
    user->present_comm = toggle_gag;
    break;
  case 'r':
    toggle_user(user, Fcomm_line);
    strcpy(message_buffer, "Who are you gonna reverse-gag?\r\n");
    strcpy(prompt_buffer, "Who: ");
    user->linecharmax = NAMEMAX;
    clear_queue(user->input);
    user->present_comm = toggle_reverse_gag;
    break;
  case 'P':
    *message_buffer = '\0';
    *prompt_buffer = '\0';
    clear_queue(user->input);
    user->present_comm = toggle_hilite;
    break;		
  case 'L':
    clear_queue(user->input);
    user->present_comm = toggle_linewrap;
    if (is_user(user, Flinewrap)) {
      *message_buffer = '\0';
      *prompt_buffer = '\0';
    } else {
      toggle_user(user, Fcomm_line);
      user->linecharmax = 3;
      strcpy(message_buffer, 
       "What width would you like for linewrap?\r\n Press <CR> for a default width of 80 characters.\r\n");
      strcpy(prompt_buffer, "Linewrap width: ");   
    }
    break;		
  case 'k':
    if (user->sec_level >= SYSOP) {
      toggle_user(user, Fcomm_line);
      strcpy(message_buffer,"Who are you gonna kick off?\r\n");
      strcpy(prompt_buffer, "Who: ");
      user->linecharmax = NAMEMAX;
      clear_queue(user->input);
      user->present_comm = kick;
      break;
    } else
      goto clueless;
  case 'Y':
    if (user->sec_level >= SYSOP) {
      toggle_user(user, Fcomm_line);
      strcpy(message_buffer, "Type out system message.\r\n");
      strcpy(prompt_buffer, "Message: ");
      clear_queue(user->input);
      user->present_comm = global_yell;
      break;
    } else
      goto clueless;
  case '+':
    if (user->sec_level == GOD) {
      toggle_user(user, Fcomm_line);
      strcpy(message_buffer, "Who's level are you gonna raise?\r\n");
      strcpy(prompt_buffer, "Who: ");
      user->linecharmax = NAMEMAX;
      clear_queue(user->input);
      user->present_comm = raise_security;
    } else
      goto clueless;
    break;
  case '-':
    if (user->sec_level == GOD) {
      toggle_user(user, Fcomm_line);
      strcpy(message_buffer, "Who's level are you gonna lower?\r\n");
      strcpy(prompt_buffer, "Who: ");
      user->linecharmax = NAMEMAX;
      clear_queue(user->input);
      user->present_comm = lower_security;
    } else
      goto clueless;
    break;
  case 'I':
    if (user->sec_level == GOD) {
      toggle_user(user, Fcomm_line);
      strcpy(message_buffer, 
       "What idletimeout (in seconds) do ya wanna set?\r\n Press <CR> to see the current idletimeout.\r\n");
      strcpy(prompt_buffer, "New idletime: ");
      user->linecharmax = 5;
      clear_queue(user->input);
      user->present_comm = set_idletime;
      break;
    } else 
      goto clueless;
  case 'u':
    *message_buffer = '\0';
    *prompt_buffer = '\0';
    clear_queue(user->input);
    user->present_comm = show_uptime;
    break;
  case 'v':
    *message_buffer = '\0';
    *prompt_buffer = '\0';
    clear_queue(user->input);
    user->present_comm = version;
    break;
  case '|':
    toggle_user(user, Fcomm_line);
    *message_buffer = '\0';
    strcpy(prompt_buffer, "Password: ");
    clear_queue(user->input);
    user->present_comm = change_security_level;
    break;
  clueless:
  default:
    strcpy(message_buffer, ">> wtf?  Type ? for help.\r\n");
    *prompt_buffer = '\0';
    clear_queue(user->input);
      user->present_comm = clueless;
      break;
  }
  return;
}


void dummy_command(user, text)
  struct user *user;
  char *text;
{
  char temp[600];

  toggle_user (user, Fcomm_line);
  if (*text) {
    sprintf(temp, "I got the text:  %s\r\n", text);
    write_user(user->desc, temp);
  } else
    write_user(user->desc, "got a NULL character\r\n"); 
}
	

void clueless (user, text)
  struct user *user;
  char *text;
{
  /* write_user (user->desc, ">> Try again.\r\n"); */
  return;
}

