.\" 
.\"     chat.1 --- Multiuser chat utility manpage
.\" 
.\"     Copyright (C) 1994  Andreas Matthias
.\" 
.\"     This program is free software; you can redistribute it and/or modify
.\"     it under the terms of the GNU General Public License as published by
.\"     the Free Software Foundation; either version 1, or (at your option)
.\"     any later version.
.\" 
.\"     This program is distributed in the hope that it will be useful,
.\"     but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"     GNU General Public License for more details.
.\" 
.\"     You should have received a copy of the GNU General Public License
.\"     along with this program; if not, write to the Free Software
.\"     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\" 
.\"     Bugs, fixes, comments to: andy@titan.central.de (Andreas Matthias)
.\" 
.\" 
.PU
.TH CHAT 1 local
.SH NAME
chat \- Multiuser chat utility
.SH SYNOPSIS
.ll +8
.B chat
.RB "<port number> [<filename>]"
.SH DESCRIPTION
.I chat
is a simple program designed to let several (up to 15) people talk together.
Users who wish to join the conversation can simply use
.I telnet(1)
to connect to the host at port
.I <port number>.
.PP
.I <port number>
is the port number that the chat utility will monitor and accept incoming
connections.  Port numbers from about 2000-5000 are recommended.  If you
are uncertain about which port numbers are unused, check the /etc/services
file and pick a number that isn't in use (see
.I services(5)). 
.PP
.I <filename>
is optional and names a text file which contains some introductory
text for new users. The contents of this file are displayed to each
user immediately after he connects to
.I chat.
.SH EXAMPLE
A good way to start
.I chat
(especially if you are new at this) is to use this command line:

      nohup chat 2001 &

The
.I nohup
command makes sure that chat will not be killed when you log out ( see
.I nohup(1)
).
The port number is 2001.  And the
.I &
makes the process run in the background.
.PP
Users may now access chat by typing:

      telnet hostname.domain.name.xyz 2001

Where hostname.domain.name.xyz is the address of the machine you started chat
from.  From that point on they will be within chat, and able to talk to other
users.
.PP
Once a user has telnet'ed to your chat program, he or she is then prompted
to enter a name for him/her self.  After the name has been accepted, the user
can type and all other users will see what was typed.
.SH COMMANDS
Commands within chat are prefixed by a % character, such as
.I %exit.
  A complete description of commands:

.I     %?
\-\- display private/global mode.  This displays whether you are in private
mode ( see
.I %p
) or in global mode.

.I     %exit
\-\- Causes chat to close your connection, effectively logging you off.

.I     %quit
\-\- same as
.I %exit.

.I     %p

.I     %p <user>
\-\- private message mode.  This allows you to talk to 
.I <user>
privately.  No one else can see anything else you type till you enter
.I %p
by itself, with no arguments.

.I     %who
\-\- displays the names of all users.

.SH "COPYLEFT"
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.SH "SEE ALSO"
telnet(1)
.SH "BUGS"
None....they're all features.  :)

.SH AUTHORS
Rolf Krahl \-\- fdes code and ideas.

Christian Holtje <docwhat@uiuc.edu> \-\- ideas and this wonderful manpage.

Andreas Matthias <andy@titan.central.de> \-\- the rest.
.SH SUGGESTIONS, BUG REPORTS, ETC.
Mail to: Andreas Matthias <andy@titan.central.de>


