/* Fairlight's ICB Client                                                    */
/* Copyright 1994, Mark Luljak <fairlite@arcadia.aldridge.sol.net>           */
/*                                                                           */


#include "flicb.h"


struct infoback *in_packet_handle(s,pkt,y,wptr,wptr2,nickm,groupm,page,pflg)
int s;
char pkt[STRINGSIZE];
int y;
WINDOW *wptr,*wptr2;
char *nickm;
char *groupm;
int page,pflg;
{
     char gbuf[STRINGSIZE],*gptr;
     char tempbuf[STRINGSIZE],*sptr,*pptr,tbuf2[STRINGSIZE],bogus[STRINGSIZE];
     char *nick, *message;
     char *status, *msg, prvnick[STRINGSIZE],fmsg[STRINGSIZE],*farr[10];
     struct tm *idletime, *logtime;
     static struct infoback infostr;
     struct infoback *iptr;
     static char hinge[12];
     static char hinge2[8];
     int rety,gonno=0;
     int helpflag=0;
     fd_set pending;
     char helpchar;
 

     iptr=&infostr;
     iptr->nickinfo=nickm;
     iptr->groupinfo=groupm;
     iptr->dopage=page;
     iptr->pageflag=pflg;
     #ifdef SYSLOG
     openlog("flicb",LOG_PID,LOG_USER);
     syslog(LOG_INFO,"dopage: %d  linesup: %d",iptr->dopage,iptr->linesup);
     #endif
     
     if (iptr->dopage == 1 && iptr->linesup >= WINSIZE) {
                    wmove(wptr2,0,0);
                    wclrtoeol(wptr2);
                    center("                         -< PRESS ANY KEY TO RESUME >-                          ",0,wptr2,1);
                    wrefresh(wptr2);
                    for (helpflag=0;!helpflag;) {
                         FD_ZERO(&pending);
                         FD_SET(fileno(stdin), &pending);
                         if (select(s + 1, &pending, NULL, NULL, NULL) < 0) {
                              perror("mainloop: select");
                              break;
                         }
                         if (FD_ISSET(fileno(stdin), &pending)) {
                              read(fileno(stdin),&helpchar,1*sizeof(char));
                              helpflag=1;
                              iptr->linesup=0;
                         }
                    }
 
     }
     sprintf(tempbuf,"%s",pkt);
     gonno=0;
     #ifdef SYSLOG
     openlog("flicb",LOG_PID,LOG_USER);
     syslog(LOG_INFO,"%s",tempbuf);
     #endif
     sprintf(bogus,"%s",tempbuf);
     sptr=bogus;
     pptr=tempbuf;
     pptr++;
     sprintf(tbuf2,"%s",pptr);
     sprintf(tempbuf,"%s",tbuf2);
     if ((int)*sptr != 'i' && iptr->pageflag==1) {
          iptr->pageflag=0;
          iptr->linesup=0;
     }
     switch ((int)*sptr) {
          case 'b':
                    nick = strtok(tempbuf,SEPCHR);
                    message = strtok(NULL,SEPCHR);
                    rety=w_pub_output(message,nick,y,0,wptr,WINSIZE,0);
                    break;

          case 'c': nick = strtok(tempbuf,SEPCHR);
                    sprintf(prvnick,"*%s*",nick);
                    message = strtok(NULL,SEPCHR);
                    rety=w_pub_output(message,prvnick,y,0,wptr,WINSIZE,1);
                    histput(nick);
                    break;

	  case 'k': nick = strtok(tempbuf,SEPCHR);
                    message = strtok(NULL,SEPCHR);
                    rety=w_beep_output(nick,message,y,0,wptr,WINSIZE);
                    break;

          case 'd': status = strtok(tempbuf,SEPCHR);
                    msg = strtok(NULL,SEPCHR);
                    sprintf(gbuf,"%s",msg);
                    rety=w_stat_output(msg,status,y,0,wptr,WINSIZE);
                    for (gptr=strtok(msg," ");gptr;gptr=strtok(NULL," ")) {
                         if (! strcmp("Group",gptr) && !strcmp(status,"Group")) {
                              gptr=strtok(NULL," ");
                              gptr=strtok(NULL," ");
                              gptr=strtok(NULL," ");
                              gptr=strtok(NULL," ");
                              sprintf(hinge2,"%s",gptr);
                              iptr->groupinfo=hinge2;
                              gonno=1;
                              break;
                         }
                         if (! strcmp("group",gptr)) {
                              gptr=strtok(NULL," ");
			      if (gptr && strcmp(gptr,"[NR]") && strtok(status,"RSVP")) {
                                   sprintf(hinge2,"%s",gptr);
                                   iptr->groupinfo=hinge2;
                                   gonno=1;
                                   break;
                              }
                         }
                    }

                    if (gonno==1) { break; }
                    
                    for (gptr=strtok(gbuf," ");gptr;gptr=strtok(NULL," ")) {
                         if (! strcmp("nickname",gptr)) {
                              gptr=strtok(NULL," ");
                              if (! strcmp("is",gptr)) {
                                   gptr=strtok(NULL," ");
                                   sprintf(hinge,"%s",gptr);
                                   iptr->nickinfo=hinge;
                                   gonno=1;
                                   break;
                              }
                         }
                    }
                    break;

          case 'e': status = strtok(tempbuf,SEPCHR);
                    rety=w_stat_output(status,"Error",y,0,wptr,WINSIZE);
                    break;

          case 'g': endwin();
                    printf("Exit Packet Received\n");
                    exit(5);
                    break;

          case 'j': status = strtok(tempbuf,SEPCHR);
                    status = strtok(NULL,SEPCHR);
                    msg = strtok(NULL,SEPCHR);
                    rety=w_ver_output(msg,status,y,0,wptr,WINSIZE);
                    break;

          case 'i': status=strtok(tempbuf,SEPCHR);
                    #ifdef SYSLOG
                    syslog(LOG_INFO,"info-type= %s",status);
                    #endif
                    if (!strcmp("wl",status)) {
			farr[0]=strtok(NULL,SEPCHR);
			farr[1]=strtok(NULL,SEPCHR);
			farr[2]=strtok(NULL,SEPCHR);
			farr[3]=strtok(NULL,SEPCHR);
			farr[4]=strtok(NULL,SEPCHR);
			farr[5]=strtok(NULL,SEPCHR);
			farr[6]=strtok(NULL,SEPCHR);
			farr[7]=strtok(NULL,SEPCHR);
			farr[8]=strtok(NULL,SEPCHR);
                        sprintf(fmsg,"  %s %-12s  %s  %s  %s@%s %s",farr[0],
				farr[1],idlestr(farr[2]),
				ampm(atoi(farr[4]),0),farr[5],farr[6],
				farr[7],farr[8]);
			#ifdef SYSLOG
                        syslog(LOG_INFO,"PRVNICK: %s",prvnick);
			#endif
                        rety=w_cmd_output(fmsg,status,y,0,wptr,WINSIZE);
                        iptr->linesup+=1;
                        iptr->pageflag=1;
                        break;
                    } 
		    if (!strcmp("wh",status) || !strcmp("gh",status)) {
                        rety=0;
                        break; 
                    }
                    if (!strcmp("co",status)) { 
                         msg = strtok(NULL,SEPCHR);
                         rety=w_cmd_output(msg,status,y,0,wptr,WINSIZE);
                         #ifdef SYSLOG
                         syslog(LOG_INFO,"co message: %s",msg);
                         #endif
                         iptr->linesup+=1;
                         iptr->pageflag=1;
                         break;
                    }
                    break;

           default: rety=0; 
                    break;
     }
     #ifdef SYSLOG
     closelog();
     #endif
     iptr->yres=rety;
     return(iptr);
}

struct infoback *out_packet_handle(s,pkt,y,wptr,pubflag,wptr2,nickm,groupm,page,pflg,liner)
int s;
char pkt[STRINGSIZE];
int y;
WINDOW *wptr;
int pubflag;
WINDOW *wptr2;
char *nickm;
char *groupm;
int page,pflg,liner;
{
     char tempbuf[STRINGSIZE],*sptr,*pptr,tbuf2[STRINGSIZE],bogus[STRINGSIZE];
     char *nick, *message;
     char *status, *msg, prvnick[STRINGSIZE],realmsg[STRINGSIZE];
     char *fairbuf;
     int rety=0,fairfl=0,firstfl=0;
     static struct infoback infostr;
     struct infoback *iptr;
     static char hinge[12];
     static char hinge2[8];
     WINDOW *helpwin;
     int helpflag;
     fd_set pending;
     char helpchar;
     FILE *pp;
     char *combuf,combuffer[MAXMSGSTRLEN];
     int g;
     char *gptr;

     #ifdef SYSLOG
     openlog("flicb",LOG_PID,LOG_USER);
     syslog(LOG_INFO,"out_packet %s",pkt);
     #endif
     iptr=&infostr;
     iptr->nickinfo=nickm;
     iptr->groupinfo=groupm;
     iptr->dopage=page;
     iptr->pageflag=pflg;
     iptr->linesup=liner;
     if (iptr->pageflag==1) {
          iptr->pageflag=0;
          iptr->linesup=0;
     }
     sprintf(tempbuf,"%s",pkt);
     sprintf(bogus,"%s",tempbuf);
     if (pubflag) {
          sprintf(realmsg,"b%s",tempbuf);
          packet_write(s,realmsg);
          rety=w_pub_output(tempbuf,nickm,y,0,wptr,WINSIZE,0);
          iptr->yres=rety;
          return(iptr);
     } 
     sptr=bogus;
     pptr=tempbuf;
     pptr++;
     if (*pptr) {
          if (*pptr != ' ') {
               rety=w_stat_output("Unknown Command.  Enter /h for a list of comands.","USER-ERROR",y,0,wptr,WINSIZE);
               iptr->yres=rety;
               return(iptr); 
          }
     }
     sprintf(tbuf2,"%s",pptr);   /* Actual Contents in non-pub msg */
     sprintf(tempbuf,"%s",pptr);
     switch ((int)*sptr) {
          case 'g': sprintf(realmsg,"hg%s%s",SEPCHR,pptr);
                    packet_write(s,realmsg);
/* THIS WAS MOVED TO in_packet_handle()
                    sprintf(hinge2,"%s",pptr);
                    iptr->groupinfo=hinge2;
*/
                    break;

          case 'e': sprintf(realmsg,"%s",pptr);
                    if (! (pp=popen(realmsg,"r"))) {
                         rety=w_stat_output("No Such Shell Command.","SHELL-ERROR",y,0,wptr,WINSIZE);
                         break; 
                    } 
                    while (!feof(pp)) {
                         combuf=combuffer;
                         fgets(combuf,MAXMSGSTRLEN,pp);
                         if (!feof(pp)) {
                              sprintf(realmsg,"b%s",combuffer);
                              packet_write(s,realmsg);
                              sprintf(prvnick,"*%s*",hinge);
                              rety=w_stat_output(combuffer,"SHELL-OUTPUT",y,0,wptr,WINSIZE);
                         }
                    }
                    pclose(pp);
                    break;

          case 'k': sprintf(realmsg,"hboot%s%s",SEPCHR,pptr);
                    packet_write(s,realmsg);
                    break;

          case 'p': sprintf(realmsg,"hpass%s%s",SEPCHR,pptr);
                    packet_write(s,realmsg);
                    break;

          case 't': sprintf(realmsg,"htopic%s%s",SEPCHR,pptr);
                    packet_write(s,realmsg);
                    break;

          case 's': sprintf(realmsg,"hstatus%s%s",SEPCHR,pptr);
                    packet_write(s,realmsg);
                    break;

          case 'i': sprintf(realmsg,"hinvite%s%s",SEPCHR,pptr);
                    packet_write(s,realmsg);
                    break;

          case 'h': 
                    helpwin=newwin(24,80,0,0);
                    box(helpwin, '|', '-');
                    help(helpwin);
                    for (helpflag=0;!helpflag;) {
                         FD_ZERO(&pending);
                         FD_SET(fileno(stdin), &pending);
                         if (select(s + 1, &pending, NULL, NULL, NULL) < 0) {
                              perror("mainloop: select");
			      break;
                         }
                         if (FD_ISSET(fileno(stdin), &pending)) {
                              read(fileno(stdin),&helpchar,1*sizeof(char));
                              helpflag=1;
                         } 
                    }
                    touchwin(wptr);
                    wrefresh(wptr);
                    touchwin(wptr2);
                    wrefresh(wptr2);
                    break;

          case 'n': sprintf(realmsg,"hnick%s%s",SEPCHR,pptr);
                    packet_write(s,realmsg);
                    sprintf(hinge,"*");
                    gptr=pptr;
                    for (g=0;g<12 && *gptr;g++) {
                         sprintf(hinge,"%s%c",hinge,*gptr);
                         gptr++; 
                    }
                    iptr->nickinfo=hinge;
                    break;

          case 'b': sprintf(realmsg,"hbeep%s%s",SEPCHR,pptr);
                    packet_write(s,realmsg);
                    break;

          case 'w': sprintf(realmsg,"hw%s%s",SEPCHR,pptr);
                    packet_write(s,realmsg);
                    break;

          case 'm': nick = strtok(tbuf2," ");
                    histput(nick);
                    #ifdef SYSLOG
                    syslog(LOG_INFO,"nick at /m packet_out %s",nick);
                    #endif
                    sprintf(prvnick,"-TO- %s",nick);
                    if (strlen(nick)<strlen(tempbuf)) {
                         fairbuf=nick;
                         fairbuf+=strlen(nick)+1;
                         sprintf(realmsg,"hm%s%s %s",SEPCHR,nick,fairbuf);
                         packet_write(s,realmsg);
                         rety=w_pub_output(fairbuf,prvnick,y,0,wptr,WINSIZE,0);
                    }
                    #ifdef SYSLOG
                    syslog(LOG_INFO,"nick at /m actual prvnick= %s",prvnick);
                    syslog(LOG_INFO,"nick at /m actual fairbuf= %s",fairbuf); 
                    closelog();
                    #endif
                    break;

          case 'c': wclear(wptr);
                    wrefresh(wptr);
                    rety=9999;
                    iptr->linesup=0;
                    break;

          case 'q': wclear(wptr2);
                    wclear(wptr);
                    wrefresh(wptr);
                    wrefresh(wptr2);
                    close(s);
                    endwin();
                    exit(0);
                    break;

           default: break;
     }
     iptr->yres=rety;
     return(iptr);
}

idlestr (num)
        char   *num;
{
        int     seconds = atoi (num);
        static char idletime[8];

        if (seconds >= 60) {
                if (seconds < 3600)
                        sprintf (idletime, "%2dm", seconds / 60);
                else
                        sprintf (idletime, "%2dh", seconds / 3600);
                return ((int)idletime);
        } else
                return ((int) "  -");
}

ampm (secs, style)
        time_t  secs;
        int     style;
{
        struct tm *t, *localtime ();
        static char timestr[12];
        int     hr, mn;

        t = localtime (&secs);
        hr = t->tm_hour;
        mn = t->tm_min;

        if (style) {
                sprintf (timestr, "%02d:%02d", hr, mn);
                return ((int)timestr);
        }
        if (hr >= 12)
                sprintf (timestr, "%2d:%02dpm", (hr > 12) ? hr - 12 : hr, mn);
        else if (hr > 0)
                sprintf (timestr, "%2d:%02dam", hr, mn);
        else
                sprintf (timestr, "12:%02dam", mn);

        return ((int)timestr);
}

