/*

Copyright 1993, 1994, Cornell University

Cornell hereby grants permission to use, copy, modify, and distribute this program for any purpose 
and without fee, provided that these copyright and permission notices appear on all copies and 
supporting documentation, the name of Cornell not be used in advertising or publicity pertaining 
to distribution of the program without specific prior permission, notice be given in supporting 
documentation that copying and distribution is by permission of Cornell.  CORNELL MAKES NO 
REPRESENTATIONS OR WARRANTEES, EXPRESS OR IMPLIED.  By way of example, but not limitation, 
CORNELL MAKES NO REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR 
PURPOSE OR THAT THE USE OF THIS SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, 
TRADEMARKS, OR OTHER RIGHTS.  Cornell shall not be held liable for any liability with respect to 
any claim by the user or any other party arising from use of the program.

This material is partially based on work sponsored by the National Science Foundation under Cooperative 
Agreement No. NCR-9318337.  The government has certain rights in this material.

*/



#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/socket.h>

#ifndef LINUX
#include <sys/socketvar.h>
#endif

#include <netinet/in.h>
#include <netdb.h>

#include "reflect.h"
#include "refmon.h"
#include "globals.h"

#define INPUTBUFSIZE 100

RefConPkt               pkt;
int                   cntrl_sock;

main(argc, argv)
    int              argc;
    char               *argv[];
{
    short               sw,len,acnt;
    char                rhost[64],buf[INPUTBUFSIZE];
    char                a1[INPUTBUFSIZE], a2[INPUTBUFSIZE], a3[INPUTBUFSIZE];
    struct sockaddr_in  raddr;
    struct hostent      *hptr;
    extern char         *optarg;

    while ((sw = getopt(argc, argv, "s:")) != -1)
       switch (sw) 
       {
          case 's':
             strcpy(rhost, optarg);
             if ((hptr = gethostbyname(rhost)) == NULL)
             {
                fprintf(stderr,"%s: unknown host\n",rhost);
                exit(1);    
             }
             break;

          case 'h':
          case '?':
             fprintf(stderr,"usage: %s -s hostname\n",argv[0]);
             exit(1);
       }

    if (hptr == NULL)
    {
       fprintf(stderr,"usage: %s -s hostname\n",argv[0]);
       exit(1);
    }

    if ((cntrl_sock = socket(AF_INET,SOCK_STREAM,0)) == 0)
    {
       perror("opening control socket");
       exit(1);
    }

    raddr.sin_family = AF_INET;
    bcopy(hptr->h_addr,&raddr.sin_addr,hptr->h_length);
    raddr.sin_port = htons(CONTROL_PORT);

    fprintf(stderr,"Waiting for connection to %s ... ",inet_ntoa(raddr.sin_addr));

    if (connect(cntrl_sock,&raddr,sizeof(raddr)) == -1)
    {
       perror("connect");
       exit(1);
    }
    fprintf(stderr,"Connected \n");


    while (1)
    {
       get_input(buf);
       acnt = sscanf(buf,"%s %s %s",a1,a2,a3);

       if (strcmp(a1,"quit") == 0)
       {
          close(cntrl_sock);
          exit(0);
       }

       if (strcmp(a1,"version") == 0)
       {
          pkt.msg_type = htons(VERSION);
          pkt.msg_len = htons(MINREFPKT);
          query(); 
          printf("%s\n",pkt.msg_data);
          continue;
       }

       if (strcmp(a1,"who") == 0)
       {
          pkt.msg_type = htons(WHO);
          pkt.msg_len = htons(MINREFPKT);
          query(); 
          printf("%s\n",pkt.msg_data);
          continue;
       }

       if (strcmp(a1,"maven") == 0)
       {
          pkt.msg_type = htons(MAVEN);
          pkt.msg_len = htons(MINREFPKT);
          query(); 
          printf("%s\n",pkt.msg_data);
          continue;
       }

       if (strcmp(a1,"uptime") == 0)
       {
          pkt.msg_type = htons(UPTIME);
          pkt.msg_len = htons(MINREFPKT);
          query(); 
          printf("%s\n",pkt.msg_data);
          continue;
       }
       if (strcmp(a1,"term") == 0)
       {
          pkt.msg_type = htons(TERM);
          pkt.msg_len = htons(MINREFPKT);
          query(); 
          printf("%s\n",pkt.msg_data);
          continue;
       }

       if (strcmp(a1,"param") == 0)
       {
          pkt.msg_type = htons(PARAM);
          pkt.msg_len = htons(MINREFPKT);
          query(); 
          printf("%s\n",pkt.msg_data);
          continue;
       }

       if (strcmp(a1,"help") == 0)
       {
          fprintf(stdout,"valid commands are: quit version help who term param maven uptime\n");
          continue;
       }

       fprintf(stdout,"command not understood\n");
       fprintf(stdout,"valid commands are: quit version help who term param maven uptime\n");

    }
}



get_input(buf)
    char *buf;
{
    short len;
    char *tmp;

    while (1)
    {
       len = 0;
       fprintf(stdout,"> ");
       bzero(buf,INPUTBUFSIZE);
       tmp = buf;

       while (1)
       {
          fscanf(stdin,"%c",tmp);
          if ((len == 0) && (*tmp == '\n'))
             break;
          if ((len != 0) && (*tmp == '\n'))
          {
             *tmp = 0;
             return;
          }
          if (len++ == INPUTBUFSIZE)
          {
             fprintf(stdout,"\nInput line too long\n");
             break;
          }
          tmp++;
       }
    }    
}


query()
{
    RefConPkt         reply_pkt;
    char              *tmp;
    short             len,remainder;

    if (write(cntrl_sock,&pkt,ntohs(pkt.msg_len)) == -1)
    {
       perror("write");
       exit(1);
    }

    if ((len = read(cntrl_sock,&reply_pkt,sizeof(reply_pkt))) == -1)
    {
       perror("read");
       exit(1);
    }

    if (len == 0)
    {
       fprintf(stderr,"connection is closed\n");
       exit(1);
    }

    if (len < MINREFPKT)
    {
       fprintf(stderr,"len is less then MINREFPKT\n");
       exit(1);
    }


    if (len == ntohs(reply_pkt.msg_len))
    {
       bcopy(&reply_pkt,&pkt,ntohs(reply_pkt.msg_len));
       pkt.msg_data[ntohs(reply_pkt.msg_len) - MINREFPKT] = 0;
       return;
    }

    remainder = ntohs(reply_pkt.msg_len) - len;
    tmp = ((char *) &reply_pkt) + len;

    while (remainder != 0)
    {
       if ((len = read(cntrl_sock,tmp,sizeof(reply_pkt))) == -1)
       {
          perror("read");
          exit(1);
       }
       tmp += len;
       remainder -= len;
    }

    bcopy(&reply_pkt,&pkt,ntohs(reply_pkt.msg_len));
    pkt.msg_data[ntohs(reply_pkt.msg_len) - MINREFPKT] = 0;
}
