/*************************************************************************/
/*                  VChat interactive IP-level chat system               */
/*-----------------------------------------------------------------------*/
/*  (c) '93/'94 by Andreas S. Wetzel (mickey@deadline.bln.sub.org)       */
/*                 All rights reserverd.                                 */ 
/*-----------------------------------------------------------------------*/
/* See the file COPYRIGHT in the top level directory of VChat for        */
/* copyright notices and further disclaimers.                            */ 
/*************************************************************************/

#include <sys/time.h>
#include <utmp.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <netdb.h>

/*** In case these are not defined in utmp.h we define them here ***/

#ifndef	_PATH_UTMP
	#define	_PATH_UTMP	"/etc/utmp"
#endif

#ifndef UT_NAMESIZE
	#define UT_NAMESIZE	8
#endif

#ifndef UT_LINESIZE
	#define	UT_LINESIZE	8
#endif

#ifndef	UT_HOSTSIZE
	#define	UT_HOSTSIZE	16
#endif

/********************** Defines ***********************/

/**********************************/
/* Command bytes client -> server */
/**********************************/

#define		SIGNON		0x41
#define		SIGNOFF		0x42
#define		CHNICK		0x43
#define		CHCHAN		0x44
#define		PRVMSG		0x45
#define		PUBMSG		0x46
#define		INVITE		0x47
#define		SND_ID		0x48
#define		ULIST		0x49
#define		PAGE		0x4A
#define		RING		0x4B
#define		WHO		0x4C

/**********************************/
/* Command bytes server -> client */
/**********************************/

#define		SERV_MSG	0x100

/*********************************/ 
/* Control-Character definitions */ 
/*********************************/ 

#define		NUL		0x0
#define		SOH		0x1 
#define		STX		0x2 
#define		ETX		0x3 
#define		EOT		0x4
#define		ENQ		0x5  
#define		ACK		0x6
#define		BEL		0x7 
#define         BS		0x8 
#define		HT		0x9 
#define		LF		0xA
#define		VT		0xB
#define		FF		0xC 
#define		CR		0xD
#define		SO		0xE  
#define		SI		0xF
#define		DLE		0x10
#define		DC1		0x11
#define		DC2		0x12
#define		DC3		0x13
#define		DC4		0x14
#define		NAK		0x15
#define		SYN		0x16
#define		ETB		0x17
#define		CAN		0x18
#define		EM		0x19 
#define		SUB		0x1A
#define		ESC		0x1B
#define		FS		0x1C
#define		GS		0x1D
#define		RS		0x1E
#define		US		0x1F
#define		DEL		0x7F

/*******************/
/* Ulist Arguments */
/*******************/

#define		ALL_CHAN	0x70
#define		MY_CHAN		0x71
#define		CHAN		0x72

/*********************/
/* Commands to VPING */
/*********************/

#define		P_PING		0x60
#define		P_WHO		0x61

/************************/
/* Responses from VPING */
/************************/

#define		OK		0x80
#define		TTY_OFAIL	0x81
#define		UTMP_OFAIL	0x82
#define		NO_ACCESS	0x83
#define		NO_LOGIN	0x84
#define		BAD_CMD		0x85
#define		BAD_DATA	0x86
#define		WHO_FAIL	0x87

/*************************************/
/* Arguments to chat_param() routine */
/*************************************/

#define		SAVE		0x2E
#define		RESTORE		0xDC

/*********************************/ 
/* Operators to scr_mode routine */ 
/*********************************/ 

#define		BLACK		0x1 
#define		WHITE		0x0 

/********************************/
/* screen attributes and colors */  
/********************************/  

#define		OFF		0x1 
#define		BOLD		0x2 
#define		UNDERLINE	0x4 
#define		BLINK		0x8
#define		REVERSE		0x10

#define		FG_BLACK	0x20
#define		FG_RED		0x40
#define		FG_GREEN	0x80
#define		FG_YELLOW	0x100
#define		FG_BLUE		0x200
#define		FG_MAGENTA	0x400
#define		FG_CYAN		0x800
#define		FG_WHITE	0x1000

#define		BG_BLACK	0x2000
#define		BG_RED		0x4000
#define		BG_GREEN	0x8000
#define		BG_YELLOW	0x10000
#define		BG_BLUE		0x20000
#define		BG_MAGENTA	0x40000
#define		BG_CYAN		0x80000
#define		BG_WHITE	0x100000

/****** Colorcodes for use in server messages *******/

#define		FG		0x0
#define		BG		0x10
#define		LOW		0x20
#define		BLK		0x80
#define		RED		0x81
#define		GRN		0x82
#define		YEL		0x83
#define		BLU		0x84
#define		MAG		0x85
#define		CYN		0x86
#define		WHT		0x87
#define		XXX		0x88

/****** Additional Character definitions ******/

#define		CTLU		NAK 
#define		CTLW		ETB 
#define		CTLR		DC2 

/**************** Control Structures ******************/

struct  client_data
{
	char    user[16];       /* Name of User who called client       */
	char    nick[32];       /* Nickname of user                     */
	long    channel;        /* Channel of User                      */
	char    host[32];       /* Hostname of User who called client   */
	struct in_addr  ip_addr;/* IP-Adsress of that host              */
	u_int   fd;             /* Filedescriptor of socket to client   */
};

struct  serv_msg
{
	int     cmd;            /* Type of Server message */
	long    len;            /* Length of server message */
};

struct  ping_cmd
{
	int     cmd;            /* Type of VPING command    */
	long    len;            /* Length of arguments      */
	char    user[16];       /* User who invoked cmd     */
	char    nick[16];       /* Nickname                 */
	char    host[16];       /* Name of invoking host.   */
	char    sv_host[16];    /* Host server runs on      */
	struct in_addr ip_addr; /* IP-addr of invoking host */
	struct in_addr sv_ipaddr;/* IP-addr of server        */
};

struct  vresp
{
	int     stat;           /* Return Status of VPING   */
	long    len;            /* Length of data following */
};

struct  user
{
	char    user[16];       /* Username */
};

struct  nickname
{
	char    nick[32];       /* Nickname to change to */
};

struct  channel
{
	signed long chan;       /* Channel to change to */
};

struct  prv_message
{
	char    receiver[16];   /* User */
	char    msg[80];        /* Message */
};

struct  invite 
{
	char    name[32];       /* User to invite to conference */
};

struct list
{
	int     cmd;                    /* What to list */
	signed long     chan;           /* Channel to list */
};

struct sysinfo 
{
	double  loadavg[3];
	long    nusers;
};

struct u_info
{
	char    u_line[UT_LINESIZE];
	char    u_name[UT_NAMESIZE];
	char    u_host[UT_HOSTSIZE];
	long    u_time;
	long	u_online;
	long	u_idle;
	char	u_command[30];
};

struct deadsnd_id
{
	long id;
	long freq;
	int bps;
	int mode;
	char title[80];
};
