/*     program: pvmstat.c     */

#include "pvm3.h"
#define MAXHOSTS 64

main()
{
  int i, mytid, nhost, narch;
  struct pvmhostinfo *hosti;
  int dtids[MAXHOSTS]; 

  /* enroll in pvm */
  mytid = pvm_mytid();

  if (pvm_config(&nhost,&narch, &hosti) < 0)
  {
    printf("\n  PVM has not been started.\n\n");
    exit();
  }
  else
  {
    printf("  The current configuration consists of %d computers.\n\n", nhost);
    printf("  TID        HOST                 ARCH         SPEED \n");
    for(i=0;i<nhost;i++)
    {    
      dtids[i] = hosti->hi_tid;
      printf("  %-10d %-20s %-12s %-8d\n",hosti->hi_tid,hosti->hi_name, hosti->hi_arch,hosti->hi_speed);
      hosti++;
    }
    printf("\n");
  }

  pvm_exit();
  exit();
}
  
