################################################################################
#
#  This PADE procedure inputs a file and allows the user to choose from a
#  list of editors.  It then runs the selected editor with the filename.
#
#  Pre: file is the value which is initially inserted into the file entry
#

proc EditFile {file {w .editfile}} {
   global penv status

   catch {destroy $w}
   toplevel $w
   wm title $w "PADE Edit File"
   wm iconname $w "Edit File"
   wm geometry $w +290+458
   $w config -cursor {arrow red white}
   
   set status 0
   tkwait visibility $w
   grab set $w

#  if an editor is not defined then get one
   if {$penv(EDITOR)==""} {
      set edtext Edit
      frame   $w.f1 -bd 1 -relief raised
      message $w.f1.msg -text "Editor command:" -width 500
      entry   $w.f1.entry -textvariable penv(EDITOR) -relief sunken -width 55
      .editfile.f1.entry delete 0 end
      pack   $w.f1.msg $w.f1.entry -side left -padx 2m -pady 5m -anchor w
   } else {
      set edtext $penv(EDITOR)
   }


#  file to edit
   frame   $w.f2 -bd 1 -relief raised
   message $w.f2.msg -text "Enter file name:  " -width 500
   entry   $w.f2.entry -textvariable file -relief sunken -width 55
   if {$file!=""} {
      .editfile.f2.entry delete 0 end
      .editfile.f2.entry insert 0 $file
   }
   pack    $w.f2.msg $w.f2.entry -side left \
      -expand 1 -padx 2m -pady 5m


#  take some action
   frame  $w.f3 -bd 1 -relief raised
   button $w.f3.edit -text $edtext -command {
      RunEditor $file
      if {$status} {
         set file ""
         destroy .editfile
      }
   }
   button  $w.f3.filefind -text "File Browser" -command {
      set ffile [FSBox "Select existing file"]
      if {$ffile!=""} {
         .editfile.f2.entry delete 0 end
         .editfile.f2.entry insert 0 $ffile
         focus .editfile.f2.entry
      }
   }
   button $w.f3.cancel -text "Cancel" -command {
      set file ""
      destroy .editfile
   }
   pack   $w.f3.filefind $w.f3.edit $w.f3.cancel \
     -side left -expand 1 -padx 3m -pady 4m -ipadx 2m -ipady 1m


#  display editor prompt only if editor is not defined
   if {$penv(EDITOR)==""} {
      pack  $w.f1 -anchor w -fill x
      pack  $w.f2 $w.f3 -fill x
      focus $w.f1.entry
      bind $w.f1.entry <Return> {focus .editfile.f2.entry}
      bind $w.f1.entry <Tab>    {focus .editfile.f2.entry}
   } else {
      pack  $w.f2 $w.f3 -fill x
      focus .editfile.f2.entry
   }

#  run editor if <Return> in filename entry
   bind $w.f2.entry <Return> {
      RunEditor $file
      if {$status} {
         set file ""
         destroy .editfile
      }
   }

   tkwait window $w
}

################################################################################

#
#  PADE run the chosen editor with the chosen file as an argument.
#

proc RunEditor {file} {
   global penv status confirm
   if {($penv(EDITOR)!="") && ($file!="")} {
      if {[string compare $penv(EDITOR) xedit]==0} {
         exec xedit $file &
      } elseif {[string compare $penv(EDITOR) nedit]==0} {
         exec nedit $file &
      } elseif {[string compare $penv(EDITOR) textedit]==0} {
         exec textedit $file &
      } else {
         exec xterm -geometry +170+218 -sl 1000 -e $penv(EDITOR) $file &
      }
      set status 1
      return
   }

   set status 0
   if {$confirm=="on"} {
      if {($penv(EDITOR)=="") && ($file=="")} {
	 Dialog .d 310 518 {PADE Warning} {Editor and file not defined} \
            error 0 {OK}
      } elseif {$file==""} {
	 Dialog .d 310 518 {PADE Warning} {File not defined} error 0 {OK}
      } elseif {$penv(EDITOR)==""} {
	 Dialog .d 310 518 {PADE Warning} {Editor not defined} error 0 {OK}
      }
   }
}

################################################################################

#
#  This PADE procedure displays the contents of a file in a listbox
#

proc ListFile {listname text} {
   global nwin winnam nline
   set nwin [expr $nwin+1]
   set winnam .$nwin
   catch {destroy $winnam}
   toplevel $winnam
   wm title $winnam "$text"
   wm iconname $winnam "$text"
   wm geometry $winnam +170+218
   $winnam config -cursor {arrow red white}
   
   global tmpname
   set tmpname $listname

   frame     $winnam.f1 -bd 1 -relief raised
   scrollbar $winnam.f1.yscroll -relief sunken -command "$winnam.f1.list yview"
   scrollbar $winnam.f1.xscroll -relief sunken \
      -command "$winnam.f1.list xview" -orient horiz
   listbox   $winnam.f1.list -xscroll "$winnam.f1.xscroll set" \
      -yscroll "$winnam.f1.yscroll set" -relief sunken -geometry 80x30 \
      -setgrid 1 -font  -*-courier-bold-r-normal--14-*-*-*-*

   set file [open $listname r]
   set nline($nwin) -1
   while {[gets $file line] >= 0} {
      $winnam.f1.list insert end $line
      set nline($nwin) [expr $nline($nwin)+1]
   }

   pack      $winnam.f1.xscroll -side bottom -fill x
   pack      $winnam.f1.yscroll -side right -fill y
   pack      $winnam.f1.list -expand 1 -fill y

   frame     $winnam.f2 -bd 1 -relief raised
   button    $winnam.f2.done -text "Done" -command "destroy $winnam"
      
   button    $winnam.f2.save -text "Save" -command {
      set savefile [FSBox "Enter file to Save output to"]
      if {$savefile!=""} {
         set ok 1
	 if {[file isdirectory $savefile]} {
            Dialog .d 200 278 {PADE Warning} \
               [concat $savefile " is not a file"] error 0 {OK}
            set ok 0
	 }
	 if {[file exists $savefile]} {
            set pick [Dialog .d 200 278 {PADE Question} \
               [concat "Overwrite " $savefile " ?"] questhead 0 \
               {Overwrite} {Cancel}]
            if {$pick} {set ok 0}
	 }
         if {$ok} {
 	    set f_savefile [open "$savefile" w]
	    set i 0
	    while {$i <= $nline($nwin)} {
	       puts $f_savefile [$winnam.f1.list get $i]
	       set i [expr $i+1]
	    }
	    close $f_savefile
         }
      }
   }
   pack $winnam.f2.save $winnam.f2.done \
      -side left -expand 1 -padx 3m -pady 4m -ipadx 2m -ipady 1m
   pack $winnam.f1 $winnam.f2 -side top -fill x
   
   focus $winnam.f1.list

   tkwait window $winnam
}
################################################################################

#
#  This PADE procedure puts up an entry box
#

proc Entry {x y string1 string2 {w .entry}} {
   global entry1 string3
   catch {destroy $w}
   toplevel $w
   wm title $w "PADE Entry"
   wm iconname $w "Entry"
   wm geometry $w +$x+$y
   $w config -cursor {arrow red white}

   grab set $w
   set string3 ""
   if {$string2!=""} {set string3 $string2}

   frame   $w.f1 -bd 1 -relief raised
   message $w.f1.msg -text $string1 -width 1000
   entry   $w.f1.entry -textvariable entry1 -relief sunken -width 55
   $w.f1.entry delete 0 end
   $w.f1.entry insert 0 $string2
   pack $w.f1.msg $w.f1.entry -side left -expand 1 -padx 2m -pady 4m

   frame   $w.f2 -bd 1 -relief raised
   button $w.f2.done -text "Done" -command {
      set entry1 [string trim $entry1]
      destroy .entry
   }
   button $w.f2.cancel -text "Cancel" -command {
      set entry1 $string3
      destroy .entry
   }
   button $w.f2.clear -text "Clear" -command {
      set entry1 ""
      .entry.f1.entry delete 0 end
   }
   button  $w.f2.filefind -text "File Browser" -command {
      set ffile [FSBox "Select file or executable"]
      if {$ffile!=""} {
         .entry.f1.entry delete 0 end
         .entry.f1.entry insert 0 $ffile
      }
   }

   pack $w.f2.clear $w.f2.filefind $w.f2.done $w.f2.cancel \
      -side left -expand 1 -padx 3m -pady 4m -ipadx 2m -ipady 1m
   pack $w.f1 $w.f2 -fill x

   focus $w.f1.entry

   bind $w.f1.entry <Return> {
      set entry1 [string trim $entry1]
      destroy .entry
   }

   tkwait window $w
}

################################################################################

#
#  This PADE procedure puts up a dialog box
#

proc Dialog {w x y title text bitmap default args } {
   global button

#  1. Create top-level window and divide into top and bottom parts

   toplevel $w -class Dialog
   wm title $w $title
   wm iconname $w Dialog
   wm geometry $w +$x+$y
   $w config -cursor {arrow red white}
   frame $w.top -relief raised -bd 1
   pack $w.top -side top -fill both
   frame $w.bot -relief raised -bd 1
   pack $w.bot -side bottom -fill both

#  2. Fill top part with bitmap and message

   message $w.top.msg -width 6i -text $text
   pack $w.top.msg -side right -expand 1 -fill both -padx 3m -pady 3m
   if {$bitmap != ""} {
      label $w.top.bitmap -bitmap $bitmap
      pack $w.top.bitmap -side left -padx 3m -pady 3m
   }

#  3. Create row of buttons at bottom of dialog

   set i 0
   foreach but $args {
      button $w.bot.button$i -text $but -command "set button $i"
      if {$i == $default} {
         frame $w.bot.default -relief sunken -bd 1
         raise $w.bot.button$i
         pack $w.bot.default -side left -expand 1 -padx 3m -pady 2m
         pack $w.bot.button$i -in $w.bot.default -side left -padx 2m -pady 2m \
            -ipadx 2m -ipady 1m
      } else {
         pack $w.bot.button$i -side left -expand 1 -padx 3m -pady 3m -ipadx 2m \
            -ipady 1m
      }
      incr i
   }

#  4. Set binding for <Return>, if there's a default set a grab and claim focus

   if {$default >= 0} {
      bind $w <Return> "$w.bot.button$default flash; \
         set button $default"
   }
   update idletasks
   set oldFocus [focus]
   grab set $w
   focus $w

#  5. Wait for use to respond, then restore focus and return index of button

   raise $w
   tkwait variable button
   destroy $w
   focus $oldFocus
   return $button
}

################################################################################

#  PADE, Look for commands in PATH environment variable
#  1 - found, 0 - not found

proc Find {cmd} {
   global env penv
   if {$penv(PATH)!=""} {
      foreach dir [split $env(PATH) ":"] {
	 if {[file isfile $dir/$cmd] && [file executable $dir/$cmd]} {return 1}
      }
      if {$cmd!=""} {
         puts "$cmd not found searching PATH environment variable"
      }
      return 0
   } else {
      return 1
   }
}
################################################################################

proc Do {varName first last body} {
   upvar $varName v
   for {set v $first} {$v <= $last} {incr v} {
      uplevel $body
   }
}

################################################################################

proc Min {list} {
   set min 0
   for {set i 1} {$i < [llength $list]} {incr i} {
      if {[lindex $list $min] > [lindex $list $i]} {set min $i}
   } 
   return $min
}
