/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*       V01.20  JRR     03-Oct-1991	Changed _MED to _MONSANTO.
*       V01.30  JRR     16-Jan-1992	Added support for RS6000.
*	V01.40	JRR	17-Jan-1992	Remove reference to SHO_ALLQUE.
*	V01.5	JRR	24-Jan-1992	Re-introduce fixes to formatting.
*	V01.6	JRR	28-Feb-1992	Added Cosmic V2 changes.
*	V01.7   JRR	30-Apr-1992     Change the sense of the -d switch.
*	V01.8	JRR	17-Jun-1992	Added header.
*	V01.9	JRR	03-Nov-1992	When processing -d switch, check for
*					a .qstat file in default directory.
*/
/*++ shoallque.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.35/lib/RCS/shoallque.c,v $
 *
 * DESCRIPTION:
 *
 *	Show information about ALL queues on the local machine as
 *	selected by the request selection and display criteria.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	August 12, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.10 $ $Date: 1993/09/10 13:55:21 $ $State: Exp $)
 * $Log: shoallque.c,v $
 * Revision 1.10  1993/09/10  13:55:21  jrroma
 * Version 3.35
 *
 * Revision 1.9  92/12/22  15:46:30  jrroma
 * Version 3.30
 * 
 * Revision 1.8  92/06/18  13:24:45  jrroma
 * Added gnu header
 * 
 * Revision 1.7  92/05/06  10:20:08  jrroma
 * Version 3.20
 * 
 * Revision 1.6  92/02/28  15:26:52  jrroma
 * Added Cosmic V2 changes.
 * 
 * Revision 1.5  92/02/12  16:16:12  jrroma
 * *** empty log message ***
 * 
 * Revision 1.4  92/01/17  13:14:59  jrroma
 * Deleted reference to SHO_ALLQUE
 * 
 * Revision 1.3  92/01/16  17:14:48  jrroma
 * Added support for RS6000.
 * 
 * Revision 1.2  91/10/03  15:22:51  jrroma
 * Changed _MED to _MONSANTO
 * 
 * Revision 1.1  91/10/03  15:21:53  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"
#include <unistd.h>			/* For getuid */
#include <string.h>

/*** shoallque
 *
 *
 *	int shoallque():
 *	Show status information on ALL of the local NQS queues.
 *
 *	WARNING:
 *		It is assumed that the current position of
 *		the queue definitions file is 0.
 *
 *	Returns:
 *		0: If output was produced.
 *	       -1: If no output was produced.
 *
 */
int shoallque (
	struct confd *file,		/* MUST be the NQS queue file */
	long flags,			/* Display flags */
	uid_t whomuid,			/* Whom we are interested in */
	struct reqset *reqs,		/* Req select set */
	short daepresent,		/* Boolean non-zero if the local */
					/* NQS daemon is present and running */
	struct confd *qmapfile,		/* Queue/device/destination mapping */
					/* file */
	struct confd *pipeqfile,	/* Pipe-queue destination file */
	int	xrmt,			/* 1 if remote, 0 if not     */
	struct confd *qcomplexfile)     /* Queue complex definition file */
{
	int result;
        Mid_t itsmid;                   /* The machine id of the queue */
        Mid_t mymid;                    /* The local machine id */
	register struct gendescr *descr;
	char *dest_queue;
	char *cp;
	FILE *domainfile;
	char domainfile_name[64];
	char hostname[256];
	char athostname[256];
	uid_t myuid;
	struct passwd *my_passwd;

	if (xrmt != 0) xrmt = 1;        /* basic programming paranoia */
	result = -1;			/* No output produced */
	descr = nextdb (file);

	while (descr != (struct gendescr *)0) {
		if (shoqbydesc (file, descr, flags, whomuid, reqs,
			daepresent, qmapfile, pipeqfile,
			qcomplexfile) == 0) {
			/*
			 *  Output was produced.
			 */
			result = 0;
                }
                descr = nextdb (file);  /* Get the next queue */
        }
        if ( flags & SHO_R_DEST) {
	    myuid = getuid();
	    my_passwd = fetchpwuid(myuid);
	    sprintf(domainfile_name,  "%s/.qstat", my_passwd->pw_dir);
	    domainfile = fopen (domainfile_name, "r");
	    if (domainfile == (FILE *) 0) {
	        sprintf(domainfile_name, "%s/nqs-domain", NQS_LIBEXE);
	        domainfile = fopen (domainfile_name, "r");
                if (domainfile == (FILE *) 0) {
		    /*
                     *  The domain file was not successfully opened.
                     */
		     fprintf(stderr,"Cannot open NQS domain file %s.\n",
				domainfile_name);
		     return (0);
	         }
	     }
	    if (localmid (&mymid) != 0) {
                fprintf (stderr, "Unexpected error in localmid().\n");
                return (0);
	    }
	    while ( (fgets(hostname, sizeof(hostname), domainfile) ) != 
			(char *) 0 ) { 
		cp = strchr(hostname, '\n');
		if (cp != (char *) 0 ) *cp = '\0';
		if (hostname[0] == '#') continue;
                /*
                 *  Output was produced.
                 */
                result = 0;
	        strcpy(athostname,  "@");
		strcat(athostname,  hostname);
		machspec (athostname, &itsmid);
        	if ((itsmid != mymid) && (xrmt == 0)) {
		    printf("Destination machine: %s\n", hostname);
		    shoqbyname (file, athostname, flags, 
			     whomuid, reqs, daepresent,qmapfile, pipeqfile,
			     qcomplexfile);

		}
	    }
	}
	return (result);
}
