/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*++ asciierrno.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs-3.21/lib/RCS/asciierrno.c,v $
 *
 * DESCRIPTION:
 *
 *
 *	Format present errno value in ASCII diagnostic string.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	April 27, 1986.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.2 $ $Date: 92/06/18 13:23:33 $ $State: Exp $)
 * $Log:	asciierrno.c,v $
 * Revision 1.2  92/06/18  13:23:33  jrroma
 * Added gnu header
 * 
 * Revision 1.1  92/06/18  09:51:25  jrroma
 * Initial revision
 * 
 *
 */

#include <stdio.h>

extern int errno;			/* System call error# */


/*** asciierrno
 *
 *
 *	char *asciierrno():
 *	Return formatted ASCII value of present errno.
 */
char *asciierrno()
{
	static char formatbuffer [20];

	sprintf (formatbuffer, "Errno value: %1d", errno);
	return (formatbuffer);
}
