/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*       V01.20  JRR     16-Jan-1992	Added support for RS6000.
*       V01.3   JRR     28-Feb-1992	Added Cosmic V2 changes.
*       V01.4   JRR     04-Mar-1992	Fixed up quotes for NQS_HOME.
*       V01.5   JRR     04-Mar-1992	Backed out NQS_HOME.
*       V01.6   JRR     13-Mar-1992	Added Nqs_dump for last chance.
*       V01.7   JRR     13-Mar-1992	Put in the comment but forgot to
*					do the work!
*	V01.8	JRR	10-Jun-1992	Set up test environment.
*	V01.9	JRR	17-Jun-1992	Added header.
*	V01.10	JRR	11-Nov-1992	Added support for HPUX>
*	V01.11	JRR	05-Mar-1993	Added Boeing enhancement for files.
*	V01.12	JRR	28-Feb-1994	Added support for SOLARIS.
*	V01.13	JRR	30-Mar-1994	Ranking compute servers.
*/
/*++ nqsdirs.h - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.36/h/RCS/nqsdirs.h,v $
 *
 * DESCRIPTION:
 *
 *	NQS daemon directory and file definitions.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	October 2, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.13 $ $Date: 1994/09/02 17:37:20 $ $State: Exp $)
 * $Log: nqsdirs.h,v $
 * Revision 1.13  1994/09/02  17:37:20  jrroma
 * Version 3.36
 *
 * Revision 1.12  94/03/30  20:31:39  jrroma
 * Version 3.35.6
 * 
 * Revision 1.11  93/07/13  21:30:01  jrroma
 * Version 3.34
 * 
 * Revision 1.10  92/12/22  15:45:21  jrroma
 * Version 3.30
 * 
 * Revision 1.9  92/06/18  09:46:22  jrroma
 * Added gnu header
 * 
 * Revision 1.8  92/06/18  09:09:40  jrroma
 * Version 3.21
 * 
 * Revision 1.7  92/03/13  15:39:03  jrroma
 * This time I did the work.
 * 
 * Revision 1.6  92/03/13  15:23:52  jrroma
 * Added Nqs_dump for last chance.
 * 
 * Revision 1.5  92/03/04  16:25:37  jrroma
 * Backed out the NQS_ROOT use (hopefully temporarily)..
 * 
 * Revision 1.4  92/03/04  16:01:16  jrroma
 * Fixed up quotes for NQS_HOME.
 * 
 * Revision 1.3  92/02/28  10:53:49  jrroma
 * Added Cosmic V2 changes.
 * 
 * Revision 1.2  92/01/17  11:44:52  jrroma
 * Added support for RS6000.
 * 
 * Revision 1.1  92/01/17  11:44:14  jrroma
 * Initial revision
 * 
 *
 */

#if	BSD43
#else
#if	HPUX | SGI | SOLARIS | SYS52 | IBMRS | ULTRIX | DECOSF 
char *Nqs_fifo = "FIFO";		/* NQS interprocess FIFO pipe */
					/* relative pathname */
char *Nqs_ffifo = "new/requests/FIFO";
					/* NQS interprocess FIFO pipe */
					/* full pathname */
#else
BAD SYSTEM TYPE
#endif
#endif
char *Nqs_requests = "new/requests";
					/* NQS new request directory */
char *Nqs_root = "private/root";
					/* NQS root directory */
char *Nqs_scripts = "scripts";
					/* NQS shell-script links directory */
char *Nqs_dump = "dump";
					/* NQS last chance directory */					
/*
 *	All of the following directories/files are relative to Nqs_root.
 */
char *Nqs_control = "control";		/* NQS control directory */
char *Nqs_data = "data";		/* NQS data directory */
char *Nqs_devices = "database/devices";	/* NQS device status file */
char *Nqs_forms = "database/forms";	/* NQS forms file */
char *Nqs_netqueues = "database/netqueues";
					/* NQS network queue/status file */
char *Nqs_queues = "database/queues";	/* NQS non-network queue/status file */
char *Nqs_qmaps = "database/qmaps";	/* NQS queue/device/destination file */
char *Nqs_pipeto = "database/pipeto";	/* NQS pipe destination queues */
char *Nqs_params = "database/params";	/* NQS general parameters file */
char *Nqs_mgracct = "database/managers";/* NQS manager account name file */
char *Nqs_servers = "database/servers"; /* NQS compute servers file */
char *Nqs_seqno = "database/seqno";	/* NQS request seq# file */
char *Nqs_qaccess = "database_qa";	/* NQS queue access directory */
char *Nqs_qorder = "database_qo";	/* NQS queue ordering directory */
char *Nqs_failed = "failed";		/* NQS failed directory */
char *Nqs_inter = "interproc";		/* NQS inter-process comm. dir. */
char *Nqs_output = "output";		/* NQS temporary output file dir. */
char *Nqs_transact = "transact";	/* NQS transaction directory */
char *Nqs_qcomplex = "database/qcomplex";
					/* NQS queue complex status file */
char *Nqs_libdir = "NQS_LIBEXE";	/* NQS default daemon directory */
char *Nqs_nmapdir = "NQS_NMAP";		/* NQS default network map directory */
char *Nqs_spooldir = "NQS_SPOOL";	/* NQS default spooling directory */
