/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                                            
*       V01.20  JRR     16-Jan-1992     Add support for RS6000.
*	V01.30	JRR	17-Jan-1992	Fix setvbuf for RS6000.
*	V01.40	JRR	12-Feb-1992	Fix setvbuf for IRIX 4.0.
*	V01.5	JRR	17-Jun-1992	Added header.
*	V01.6	JRR	05-Nov-1992	Added HPUX support.
*	V01.7	JRR	06-Jan-1993	Only support IRIX 4.0 now.
*	V01.8	JRR	06-Apr-1993	Added DECOSF support.
*	V01.9	JRR	28-Feb-1994	Added support for SOLARIS.
*/
/*++ bufstderr.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.35.6/lib/RCS/bufstderr.c,v $
 *
 * DESCRIPTION:
 *
 *	Block buffer the output to the stderr file stream.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	October 27, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.9 $ $Date: 1994/03/30 20:32:24 $ $State: Exp $)
 * $Log: bufstderr.c,v $
 * Revision 1.9  1994/03/30  20:32:24  jrroma
 * Version 3.35.6
 *
 * Revision 1.8  93/07/13  21:30:58  jrroma
 * Version 3.34
 * 
 * Revision 1.7  93/02/05  23:13:13  jrroma
 * Version 3.31
 * 
 * Revision 1.6  92/11/06  10:57:09  jrroma
 * Added support for HPUX.
 * 
 * Revision 1.5  92/06/18  13:23:34  jrroma
 * Added gnu header
 * 
 * Revision 1.4  92/02/12  10:25:36  jrroma
 * Fix setvbuf for Irix 4.0
 * 
 * Revision 1.3  92/01/17  15:46:03  jrroma
 * Fix up reference to setvbuf for RS6000.
 * 
 * Revision 1.2  92/01/16  15:11:37  jrroma
 * Adding support for RS6000.
 * 
 * Revision 1.1  92/01/16  15:09:05  jrroma
 * Initial revision
 * 
 *
 */

#include <stdio.h>


/*** bufstderr
 *
 *
 *	void bufstderr():
 *	Block buffer the output to the stderr file stream.
 */
void bufstderr()
{
	static char stderr_buffer [BUFSIZ];	/* Stderr output buffer */

#if	BSD43 | ULTRIX | DECOSF
	setbuffer (stderr, stderr_buffer, BUFSIZ);
#else
#if	IBMRS | SGI | SOLARIS | HPUX
	/*
	 *  These guys took AT&T at their word....
	 */
	setvbuf (stderr, stderr_buffer, _IOFBF, BUFSIZ);
#else
BAD SYSTEM TYPE
#endif
#endif
}
