/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*       V01.20  JRR     16-Jan-1992	Added support for RS6000.
*	V01.3	JRR	17-Jun-1992	Added header.
*	V01.4	JRR	06-Apr-1993	Added support for DECOSF
*					(by deleting conditionals).
*/
/*++ getreq.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.34/lib/RCS/getreq.c,v $
 *
 * DESCRIPTION:
 *
 *	Read the entire control file header for an NQS control file.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	August 12, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.5 $ $Date: 1993/07/13 21:31:22 $ $State: Exp $)
 * $Log: getreq.c,v $
 * Revision 1.5  1993/07/13  21:31:22  jrroma
 * Version 3.34
 *
 * Revision 1.4  92/11/06  12:53:07  jrroma
 * Added support for HPUX.
 * 
 * Revision 1.3  92/06/18  13:23:51  jrroma
 * Added gnu header
 * 
 * Revision 1.2  92/01/16  15:48:20  jrroma
 * Added support for RS6000.
 * 
 * Revision 1.1  92/01/16  15:47:26  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"
#include "nqsxdirs.h"			/* Get Nqs_control defn */

/*** getreq
 *
 *
 *	int getreq():
 *	Open/read the request header portion of the control file for an
 *	NQS request.
 *
 *	Returns:
 *	      >=0: if successful, in which case the value returned
 *		   is the file descriptor opened for reading/writing
 *		   the control file;
 *	       -1: if the req control file was invalid, or an open
 *		   error occurred.
 *
 *			Note:	errno is returned 0, unless some system
 *				call error has occurred.
 */
int getreq (orig_seqno, orig_mid, rawreq)
long orig_seqno;		/* Sequence number of req */
Mid_t orig_mid;			/* Machine-id of req */
struct rawreq *rawreq;		/* Raw request information to be returned */
{
	char path [MAX_PATHNAME+1];	/* Control directory pathname */
	register int fd;		/* File descriptor for control file */

	pack6name (path, Nqs_control, (int) (orig_seqno % MAX_CTRLSUBDIRS),
		  (char *) 0, (long) orig_seqno, 5, (long) orig_mid, 6, 0, 0);
	if ((fd = open (path, O_RDWR)) == -1) {
		/*
		 *  Unable to open the control file.
		 *  Errno has error code.
		 */
		return (-1);
	}
	if (readreq (fd, rawreq) == 0) return (fd);	/* Success */
	close (fd);					/* Close the file */
	return (-1);					/* Bad control file */
}
