/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*       V01.20  JRR     16-Jan-1992	Added support for RS6000.
*	V01.3	JRR	17-Jun-1992	Added header.
*	V01.4	JRR	02-Feb-1994	Fixed NETDB.
*/
/*++ localmid.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.35.6/lib/RCS/localmid.c,v $
 *
 * DESCRIPTION:
 *
 *	Return the machine-id of the local host.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	October 11, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.4 $ $Date: 1994/03/30 20:32:35 $ $State: Exp $)
 * $Log: localmid.c,v $
 * Revision 1.4  1994/03/30  20:32:35  jrroma
 * Version 3.35.6
 *
 * Revision 1.3  92/06/18  13:24:04  jrroma
 * Added gnu header
 * 
 * Revision 1.2  92/01/16  15:55:59  jrroma
 * Added support for RS6000.
 * 
 * Revision 1.1  92/01/16  15:55:12  jrroma
 * Initial revision
 * 
 *
 */

#include <netdb.h>			/* Network database declarations */
#include "nmap.h"				/* Network mapping codes */

extern int nmap_get_mid();		/* Get machine-id for name */

/*** localmid
 *
 *
 *	int localmid():
 *	Return the machine-id of the local host.
 *
 *	Returns:
 *		0: if successful, in which case the machine_id
 *		   parameter is properly set.
 *
 *	       -2: if the local machine-id is not defined in the
 *		   local host's mapping tables (NMAP_ENOMAP).
 *
 *	       -3: if the Network Mapping Procedures (NMAP_)
 *		   deny access to the caller (NMAP_ENOPRIV).
 *
 *	       -4: if some other general NMAP_ error occurs.
 */
int localmid (machine_id)
Mid_t *machine_id;			/* Pointer of where to return */
					/* the proper machine-id */
{
	static short local_is_known = 0;/* Boolean non-zero if the */
					/* local machine-id is stored */
					/* in local_mid. */
	static Mid_t local_mid;		/* Machine-id of local machine */

	if (local_is_known) {
		/*
		 *  The local machine-id is known from a previous
		 *  call.
		 */
		*machine_id = local_mid;
		return (0);		/* Success */
	}
	switch (nmap_get_mid ((struct hostent *) 0, machine_id)) {
	case NMAP_SUCCESS:		/* Successfully got local machine-id */
		local_mid = *machine_id;
		local_is_known = 1;
		return (0);
	case NMAP_ENOMAP:		/* What?  No local mid defined! */
		return (-2);
	case NMAP_ENOPRIV:		/* No privilege */
		return (-3);
	}
	return (-4);			/* General NMAP_ error */
}
