/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*++ mkdefault.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs-3.21/lib/RCS/mkdefault.c,v $
 *
 * DESCRIPTION:
 *
 *	Manufacture a default output file name.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	August 12, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.2 $ $Date: 92/06/18 13:24:12 $ $State: Exp $)
 * $Log:	mkdefault.c,v $
 * Revision 1.2  92/06/18  13:24:12  jrroma
 * Added gnu header
 * 
 * Revision 1.1  92/06/18  11:42:58  jrroma
 * Initial revision
 * 
 *	Modified by jrr for mtcamm with longer request names!
 *
 */

#include "nqs.h"

/*** mkdefault
 *
 *
 *	void mkdefault():
 *	Make a default output file name.
 */
void mkdefault (cp, path, reqname, seqno, suffix_char)
register char *cp;		/* Destination for name */
register char *path;		/* Path for file name */
register char *reqname;		/* Req name */
long seqno;			/* Req sequence number */
char suffix_char;		/* Suffix character: 'e' or 'o' */
{
	register int i;

	if (*path != '\0') {
		do {
			*cp++ = *path++;
		} while (*path);
		*cp++ = '/';
	}
	for (i=0; i < MAX_REQNAME && *reqname != '\0'; i++) {
		*cp++ = *reqname++;
	}
	*cp++ = '.';
	*cp++ = suffix_char;
	sprintf (cp, "%1ld", seqno);
}
