/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*++ readdb.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.30/lib/RCS/readdb.c,v $
 *
 * DESCRIPTION:
 *
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	August 12, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.3 $ $Date: 1992/12/22 15:46:22 $ $State: Exp $)
 * $Log: readdb.c,v $
 * Revision 1.3  1992/12/22  15:46:22  jrroma
 * Version 3.30
 *
 * Revision 1.2  92/06/18  13:24:31  jrroma
 * Added gnu header
 * 
 * Revision 1.1  92/06/18  12:45:38  jrroma
 * Initial revision
 * 
 *
 */
#include "nqs.h"

/*** readdb
 *
 *
 *	struct gendescr *readdb():
 *
 *	Read a gendescr structure from the current position updating
 *	the specified configuration file position to the next gendescr
 *	structure in the file.  Note that the gendescr structure
 *	returned may not contain any data (it may be unallocated).
 *
 *	Returns:
 *		A pointer to the gendescr structure just read if
 *		successful; otherwise a NULL pointer value is returned
 *		(indicating EOF).
 */
struct gendescr *readdb (file)
register struct confd *file;
{
	register struct gendescr *gendescr;
	register int size;

	if (file->vposition >= file->size) return ((struct gendescr *) 0);
						/* EOF */
	seekdbb (file, file->vposition);
	gendescr = (struct gendescr *) (file->cache->v.chars
		 +  file->vposition % ATOMICBLKSIZ);
	file->lastread = file->vposition;	/* Remember last read address */
	size = gendescr->size;
	if (size < 0) size = -size;		/* Descriptor is unallocated */
	file->vposition += size;		/* Update virtual position */
	return (gendescr);			/* Return ptr to descriptor */
}
