/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*       V01.20  JRR     16-Jan-1992	Added support for RS6000.
*	V01.3	JRR	17-Jun-1992	Added header.
*	V01.4	JRR	05-Nov-1992	Modified for C prototypes.
*/
/*++ shodbyname.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.35/lib/RCS/shodbyname.c,v $
 *
 * DESCRIPTION:
 *
 *	Print on stdout information about a device.
 *
 *
 *	Author:
 *	-------
 *	Robert W. Sandstrom, Sterling Software Incorporated.
 *	December 18, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.5 $ $Date: 1993/09/10 13:55:22 $ $State: Exp $)
 * $Log: shodbyname.c,v $
 * Revision 1.5  1993/09/10  13:55:22  jrroma
 * Version 3.35
 *
 * Revision 1.4  92/12/22  15:46:31  jrroma
 * Version 3.30
 * 
 * Revision 1.3  92/06/18  13:24:47  jrroma
 * Added gnu header
 * 
 * Revision 1.2  92/01/16  17:15:56  jrroma
 * Added support for RS6000.
 * 
 * Revision 1.1  92/01/16  17:15:12  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"			/* NQS types and definitions */


/*** shodbyname
 *
 *
 *	int shodbyname():
 *
 *	Print on stdout information about the named device.
 *	Returns: 0 if output was produced.
 *		-1 if no output was produced.
 */
int shodbyname (devicefile, fullname)
struct confd *devicefile;
char *fullname;
{
	struct gendescr *descr;
	int found;
	Mid_t itsmid;
	Mid_t mymid;
	char *localname;

	switch (machspec (fullname, &itsmid)) {
		case 0:
			break;
		case -1:
		case -2:
			fprintf (stderr, "Invalid hostname specification ");
			fprintf (stderr, "for device %s.\n", fullname);
			return (0);
		case -3:
		case -4:
			fprintf (stderr, "Unexpected error in machspec(), ");
			fprintf (stderr, "device = %s.\n", fullname);
			return (0);
	}
	if (localmid (&mymid) != 0) {
		fprintf (stderr, "Unexpected error in localmid().\n");
		return (0);
	}
	if (itsmid == mymid) {
		found = 0;
		if (telldb (devicefile) != -1) {
			/*
			 *  We are not necessarily at the start of the
			 *  database file....
			 */
			seekdb (devicefile, 0L);/* Seek to the beginning */
		}
		descr = nextdb (devicefile);
		localname = destdev (fullname);
		while (descr != NULL && !found) {
			if (strcmp (descr->v.dev.dname, localname) == 0) {
				found = 1;
			}
			else descr = nextdb (devicefile);
		}
		if (found) return (shodbydesc (descr));
		else {
			fprintf (stderr, "Device: %s does not exist.\n",
				 fullname);
			return (0);
		}
	}
	else {
		fprintf (stderr, "You are asking about a remote device.\n");
		fprintf (stderr, "Networking is not supported in this ");
		fprintf (stderr, "implementation.\n");
		return (0);
	}
}
