/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR     21-Jul-1993     Initial version.

*/
/*++ finish_autoinst.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.35/src/RCS/finish_autoinst.c,v $
 *
 * DESCRIPTION:
 *
 *  This program completes the auto-install process.  It does the following:
 *	1. executes the script NQS_STAGE_LOC/install_nqs to move the
 *	   various files to the appropriate locations.
 *	2. It starts NQS back up again.
 *	3. (Optional) It sends a mail message to the desired address.
 *
 *	This program MUST run as setuid to root program, in order
 *	to signal the NQS shepherd process running as root.
 *
 *
 *	Author:
 *	-------
 *	John Roman, Monsanto Company.
 *	July 21,  1993.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 *
 */

#include <stdlib.h>

/*** main
 *
 *
 *	Invocation is as follows:
 *
 *	  $(NQS_LIBEXE)/finish_autoinst  $(NQS_LIBEXE)
 *
 */
main (argc, argv)
int argc;
char *argv[];
{

    char buffer[512];
    
    /*
     * System the install_nqs script.
     */
    strcpy (buffer, NQS_STAGE_LOC);
    strcat (buffer, "/install_nqs");
    
    system (buffer);
    
    /*
     * Startup NQS...
     */
     
    sprintf(buffer, "%snqsdaemon > /dev/null &", argv[1]);

    system (buffer);

    /*
     * Currently commented out -- modify if desired...
     *
     * sprintf(buffer, "Mail -s \"NQS automatically installed\" root </dev/null");
     *
     * system (buffer);
     */
}
