/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*++ nqs_abort.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.30/src/RCS/nqs_abort.c,v $
 *
 * DESCRIPTION:
 *
 *	Abort NQS daemon execution.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	August 12, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.3 $ $Date: 1992/12/22 15:39:46 $ $State: Exp $)
 * $Log: nqs_abort.c,v $
 * Revision 1.3  1992/12/22  15:39:46  jrroma
 * Version 3.30
 *
 * Revision 1.2  92/06/18  17:30:52  jrroma
 * Added gnu header
 * 
 * Revision 1.1  92/06/18  14:59:35  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"
#include "nqsxvars.h"			/* NQS global vars */
#include <errno.h>


/*** nqs_abort
 *
 *
 *	void nqs_abort():
 *
 *	Abort execution of the NQS daemon writing a message to
 *	the NQS log process.
 */
void nqs_abort ()
{
	if (errno) printf ("I$%s.\n", asciierrno());
	printf ("I$Execution aborted.\n");
	fflush (stdout);
	exit (1);
}
