/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.1   JRR     21-Sep-1992     Initial version.
*	V01.2	JRR	26-Feb-1992	Add Boeing enhancement for Mids.
*	V01.3	JRR	24-Aug-1993	If we get load information for a
*					machine in retry or failed state, 
*					schedule a retry 30 seconds later.
*/
/*++ nqs_load.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.35/src/RCS/nqs_load.c,v $
 *
 * DESCRIPTION:
 *
 *	NQS load module.
 *
 *
 *	Author:
 *	-------
 *	John Roman, Monsanto Company.
 *	September 21, 1992.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.3 $ $Date: 1993/09/10 13:57:15 $ $State: Exp $)
 * $Log: nqs_load.c,v $
 * Revision 1.3  1993/09/10  13:57:15  jrroma
 * Version 3.35
 *
 * Revision 1.2  93/07/13  21:33:51  jrroma
 * Version 3.34
 * 
 * Revision 1.1  92/12/22  15:39:56  jrroma
 * Version 3.30
 * 
 * 
 *
 */
#include "nqs.h"
#include "nqsxvars.h"
#include "transactcc.h"		/* Transaction completion codes */
#include <malloc.h>

/*** nqs_load
 *
 *	Store the load information for this Mid in an internal data
 *	structure.
 *
 *	Returns:
 *		TCML_COMPLETE:	if successful;
 */
long nqs_load (mid, version, nqs_jobs, string)
Mid_t mid;
int version;
int nqs_jobs;
char *string;
{
    struct loadinfo *loadinfo_ptr;
    float load1,  load5,  load15;   
    struct pipeto *dest;	/* Pipe queue destination */
    time_t timenow;	/* Current time */
    
    if (Debug > 2)  {
        printf("D$Nqs_load: Entering with mid %u jobs %d \n", mid,  nqs_jobs);
        fflush (stdout);
    }
    sscanf(string,  "%f %f %f",  &load1,  &load5,  &load15);
    /*
     * Look through the queue of loadinfos for this mid.  If it is
     * there,  replace the contents with the new information.  If it is
     * not,  create a new structure.
     */
    loadinfo_ptr = Loadinfo_head.next;
    while (loadinfo_ptr != (struct loadinfo *) 0) {
	if (loadinfo_ptr->mid == mid) {
	    time (&loadinfo_ptr->time);
	    loadinfo_ptr->no_jobs = nqs_jobs;
	    loadinfo_ptr->load1 = load1;
	    loadinfo_ptr->load5 = load5;
	    loadinfo_ptr->load15 = load15;
	    break;
	} else {
	    loadinfo_ptr = loadinfo_ptr->next;
	}
    }
    if (loadinfo_ptr == (struct loadinfo *) 0) {
	loadinfo_ptr = (struct loadinfo *) malloc (sizeof (Loadinfo_head) );
	loadinfo_ptr->mid = mid;
	time (&loadinfo_ptr->time);
	loadinfo_ptr->no_jobs = nqs_jobs;
	loadinfo_ptr->load1 = load1;
	loadinfo_ptr->load5 = load5;
	loadinfo_ptr->load15 = load15;
	loadinfo_ptr->next = Loadinfo_head.next; 
	Loadinfo_head.next = loadinfo_ptr;
    }
    /*
     *  If this machine is not enabled, set it to retry in 30 seconds.
     */
    dest = Pipetoset;
    while (dest != (struct pipeto *) 0) {
	if (dest->rhost_mid == mid) {
	    /*
	     *  Perform update on this destination.
	     */
	    if ( !(dest->status & DEST_ENABLED) ) {
		timenow = time ((time_t *) 0);
		dest->status = DEST_RETRY;
		dest->retry_at = timenow + 30;
		/*
		 *  Set timer to re-enable the destination.
		 */
		nqs_vtimer (&dest->retry_at, nqs_wakdes);
		udb_destination (dest);	/* Update NQS database image */
	    }
	}
	dest = dest->next;		/* Next destination */
    }	 
    return (TCML_COMPLETE);
}
