/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*       V01.20  JRR     16-Jan-1992	Added support for RS6000.
*       V01.3   JRR     03-Mar-1992	Added Cosmic V2 changes.
*	V01.4	JRR	17-Jun-1992	Added header.
*	V01.5	JRR	10-Nov-1992	Added support for HPUX. 
*	V01.6	JRR	08-Mar-1993	Added Boeing enhancement for files.
*/
/*++ qdev.c - Network Deviceing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.35/src/RCS/qdev.c,v $
 *
 * DESCRIPTION:
 *
 *	Display device status information.
 *	This program must run as a setuid root program.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	October 24, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.7 $ $Date: 1993/08/17 16:08:30 $ $State: Exp $)
 * $Log: qdev.c,v $
 * Revision 1.7  1993/08/17  16:08:30  jrroma
 * *** empty log message ***
 *
 * Revision 1.6  93/07/13  21:34:08  jrroma
 * Version 3.34
 * 
 * Revision 1.5  92/12/22  15:43:21  jrroma
 * Version 3.30
 * 
 * Revision 1.4  92/06/17  08:45:35  jrroma
 * Version 3.21
 * 
 * Revision 1.3  92/03/03  13:40:31  jrroma
 * Added Cosmic V2 changes.
 * 
 * Revision 1.2  92/01/17  11:24:44  jrroma
 * Added support for RS6000.
 * 
 * Revision 1.1  92/01/17  11:24:11  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"
#include "nqsdirs.h"			/* NQS files and directories */


/*
 *	Global variables:
 */
char *Qdev_prefix = "Qdev";

/*** main
 *
 *
 *	qdev [ <device-name(s)> ]
 */
main (argc, argv)
int argc;
char *argv[];				/* Possible list of devices */
{
	struct confd *devicefile;
        int exitcode = 0;                       /* Function exit code */
	char *root_dir;                 /* Fully qualified file name */

	if ( ! buildenv()) {
	    fprintf (stderr, "%s(FATAL): Unable to ", Qdev_prefix);
	    fprintf (stderr, "establish directory independent ");
	    fprintf (stderr, "environment.\n");
	    exit (1);
	}

	root_dir = getfilnam (Nqs_root, SPOOLDIR);
	if (root_dir == (char *)NULL) {
	    fprintf (stderr, "%s(FATAL): Unable to ", Qdev_prefix);
	    fprintf (stderr, "determine root directory name.\n");
	    exit (1);
	}
	if (chdir (root_dir) == -1) {
	    fprintf (stderr, "%s(FATAL): Unable to chdir() to the NQS ",
                 Qdev_prefix);
	    fprintf (stderr, "root directory.\n");
	    relfilnam (root_dir);
	    exit (1);
	}
	relfilnam (root_dir);
	if ((devicefile = opendb (Nqs_devices, O_RDONLY)) == NULL) {
		fprintf (stderr, "%s(FATAL): Unable to open the NQS device ",
			 Qdev_prefix);
		fprintf (stderr, "definition database file.\n");
		exit (1);
	}
	/*
	 *  Block buffer stdout for efficiency.
	 */
	bufstdout();
        if (*++argv == NULL)  exitcode |= shoalldev (devicefile);
	else {
		while (*argv != NULL) {		/* Show info on a device */
                        exitcode |= shodbyname (devicefile, *argv);
			argv++;
		}
	}
	/*
	 *  Flush output buffers and exit.
	 */
	fflush (stdout);
	fflush (stderr);
	exit (exitcode);
}
