/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*       V01.2   JRR     05-Mar-1992	Called it qstatc and got it to run
*					here.
*	V01.3	JRR	17-Jun-1992	Added header.
*/
/*++ qstat.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs-3.21/src/RCS/qstatc.c,v $
 *
 * DESCRIPTION:
 *
 *	Display status information.
 *	This program must run as a setuid program.
 *
 *	Since the method of arriving at the target displays are
 *	the same they share the same major sections of code.
 *	The arguments and target is passed onto main_dsp().
 *	This is ease in maintainability and readability.
 *
 *	The shared code may be found in lib/main_dsp.  Each
 *	set of code that is specific to queues, requests, and
 *	complexs may be found in queues.c, requests.c and complexes.c
 *	
 */

#include <stdio.h>
#include "nqs.h"

int	DEBUG;

/*** main
 *
 *
 *	qstat [-b] [-p] [-d] [-f] [-L] [-n] [-x] [-A] [-g] [-u] [-U] [-T] [-h] 
 *		[ <queue-name(s)> ]
 */
main (argc, argv)
int argc;
char *argv[];
{
	long flags=0;
	char * selector=NULL;
	char * tname=NULL;
 	char * hname=NULL;
	int	i;

	/* step 1. parse the command line */
	flags = parse_args(&argc, argv,"abdfg:h:lnps:u:xA:LT:U",&selector,
		&tname,&hname);


	/* step 2. set SHO_QUE so we know the object to deal with  */

	/* If the options are -L, -b, -d, or -p, then we concerned */
	/* with the queues . . .                                   */

	if ((flags & SHO_LIMITS) || (flags & SHO_BATCH) ||
	    (flags & SHO_DEVICE) || (flags & SHO_PIPE))
	  flags |= SHO_QUE;

	/* If the options are -A acct, -T user, -U, -a, -g group,  */
	/* -s state, or -u user, . . . in other words, anything    */
	/* else (or nothing) . . . then we are concerned with      */
	/* requests.                                               */

	else
	  flags |= SHO_REQ;

	
	/* step 3. display the information */
	main_dsp(argc,argv,flags,selector,tname,hname);
	printf("\n");

}

