/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*       V01.20  JRR     26-May-1992	Added support for RS6000.
*		JRR	27-May-1992     Modified to add sequence number.
*	V01.3	JRR	17-Jun-1992	Added header.
*	V01.4	JRR	21-Sep-1992	Added startup and shutdown record 
*					Added completion time to completion 
*					record.
*			04-Nov-1992	Added status message.	
*	V01.5	JRR	26-Feb-1993	Fixed up Mids.
*			05-Apr-1993	Added INIT_1 message type.
*			15-Apr-1993	Added SUMM message type.
*	V01.6	JRR	28-Feb-1994	Added support for SOLARIS.
*
*/
#if	TEST
#define NQSACCT_FILE	"/usr/adm/xnqs"	/* file for NQS account records */
#else
#define NQSACCT_FILE	"/usr/adm/nqs"	/* file for NQS account records */
#endif
#define NQSACCT_INIT	1		/* job initiation record */
#define NQSACCT_FIN	2		/* job terminiation record */
#define NQSACCT_STARTUP 3		/* NQS startup record */
#define NQSACCT_SHUTDOWN 4		/* NQS shutdown record */
#define NQSACCT_FIN_1	5		/* job terminiation record -- new style */
#define NQSACCT_STAT	6		/* job status record */
#define NQSACCT_INIT_1	7		/* job initiation record -- new style */
#define NQSACCT_SUMM	8		/* Summary record */

/*
 *	NQS account file record header.
 */
struct	nqsacct	{
	int	type;			/* type of record */
	int	length;			/* length of record (bytes) */
	int	jobid;			/* UNICOS job id */
};

/*
 *	NQS account file record for job initiation.
 */
struct	nqsacct_init {
	struct	nqsacct h;      /* NQS account record header */
	char	user[16];		/* user name */
	char	queue[16];		/* NQS queue name */
	int	priority;		/* priority of NQS queue */
	time_t	sub_time;		/* time submitted */
	time_t	start_time;		/* requested start time "-a" */
	time_t	init_time;		/* time initiated */
	Mid_t	orig_mid;		/* originating machine ID */
	char	scp_tid[8];		/* station TID */
	char	scp_mf[2];		/* station mainframe ID */
	long	seqno;			/* original sequence number */
};
/*
 *	New style NQS account file record for job initiation.
 */
struct	nqsacct_init1 {
	struct	nqsacct h;      /* NQS account record header */
	char	user[16];		/* user name */
	char	queue[MAX_QUEUENAME+1];	/* NQS queue name */
	int	priority;		/* priority of NQS queue */
	time_t	sub_time;		/* time submitted */
	time_t	start_time;		/* requested start time "-a" */
	time_t	init_time;		/* time initiated */
	Mid_t	orig_mid;		/* originating machine ID */
	long	seqno;			/* original sequence number */
	char    reqname[MAX_REQNAME+1]; /* request name */
};

/*
 * 	NQS account file record for job termination.
 */
struct 	nqsacct_fin {
	struct	nqsacct h;		/* NQS account record header */
	char	user[16];		/* user name */
	char 	queue[16];		/* NQS queue name */
	long	seqno;			/* Original sequence number */
#if    HPUX | SGI | SOLARIS | SYS52 | IBMRS
	long	tms_stime;		/* Time spent by system for this job */
	long	tms_utime;		/* Time spent by user for this job */
#else
#if	BSD43 | ULTRIX | DECOSF
	long	s_sec;			/* System time in seconds */
	long	s_usec;			/* System time in microseconds */
	long	u_sec;			/* User time in seconds */
	long	u_usec;			/* User time in microseconds */
#else
BAD SYSTEM TYPE
#endif
#endif
	Mid_t	orig_mid;		/* Originating Machine ID */
};
/*
 * 	NQS account file record for job termination -- new style
 */
struct 	nqsacct_fin1 {
	struct	nqsacct h;		/* NQS account record header */
	char	user[16];		/* user name */
	char 	queue[16];		/* NQS queue name */
	long	seqno;			/* Original sequence number */
#if    HPUX | SGI | SOLARIS | SYS52 | IBMRS
	long	tms_stime;		/* Time spent by system for this job */
	long	tms_utime;		/* Time spent by user for this job */
#else
#if	BSD43 | ULTRIX | DECOSF
	long	s_sec;			/* System time in seconds */
	long	s_usec;			/* System time in microseconds */
	long	u_sec;			/* User time in seconds */
	long	u_usec;			/* User time in microseconds */
#else
BAD SYSTEM TYPE
#endif
#endif
	Mid_t	orig_mid;		/* Originating Machine ID */
	time_t	fin_time;		/* Time completed */
};
/*
 *	NQS account file record for startup.
 */
struct	nqsacct_startup {
	struct	nqsacct h;		/* NQS account record header */
	time_t 	start_time;		/* Time nqs started up */
};
/*
 *	NQS account file record for shutdown.
 */
struct	nqsacct_shutdown {
	struct	nqsacct h;		/* NQS account record header */
	time_t 	down_time;		/* Time nqs shutdown */
};
/*
 * Summary record.
 */
struct nqsacct_summ {
	struct	nqsacct h;		/* NQS account record header */
        char    user[16];               /* user name */
        char    queue[MAX_QUEUENAME+1]; /* NQS queue name */
	char    reqname[MAX_REQNAME+1]; /* Request name */
        int     priority;               /* priority of NQS queue */
        time_t  sub_time;               /* time submitted */
        time_t  start_time;             /* requested start time "-a" */
        time_t  init_time;              /* time initiated */
        time_t  fin_time;               /* Time completed */
        Mid_t   orig_mid;               /* originating machine ID */
        long    seqno;                  /* original sequence number */
	long	u_time;			/* User time */
	long	s_time;			/* System time */
};

/*
 * This record type is only used internally by qacct.
 */
struct acct_record {
	struct acct_record *next;
        char    user[16];               /* user name */
        char    queue[MAX_QUEUENAME+1]; /* NQS queue name */
	char    reqname[MAX_REQNAME+1]; /* Request name */
        int     priority;               /* priority of NQS queue */
        time_t  sub_time;               /* time submitted */
        time_t  start_time;             /* requested start time "-a" */
        time_t  init_time;              /* time initiated */
        time_t  fin_time;               /* Time completed */
        Mid_t   orig_mid;               /* originating machine ID */
        long    seqno;                  /* original sequence number */
#if    HPUX | SGI | SOLARIS | SYS52 | IBMRS
        long    tms_stime;              /* Time spent by system for this job */ 
	long    tms_utime;              /* Time spent by user for this job */
#else
#if     BSD43 | ULTRIX | DECOSF
        long    s_sec;                  /* System time in seconds */
        long    s_usec;                 /* System time in microseconds */
        long    u_sec;                  /* User time in seconds */
        long    u_usec;                 /* User time in microseconds */
#else
BAD SYSTEM TYPE
#endif
#endif
};

