/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*       V01.20  JRR     16-Jan-1992	Added support for RS6000.
*       V01.3   JRR     12-Feb-1992	Fixed timezone support for Irix 4.0.
*					And then changed it back.
*       V01.4   JRR     07-Apr-1992     Added CERN enhancements.
*	V01.5	JRR	26-May-1992	Fixed definition of tm for ibm.
*	V01.6	JRR	17-Jun-1992	Added header.
*	V01.7	JRR	06-Nov-1992	Added support for HPUX.
*	V01.8	JRR	07-Dec-1992	Modified for C prototypes.
*	V01.9	JRR			Placeholder
*	V01.10	JRR	28-Feb-1994	Added support for SOLARIS
*/
/*++ fmttime.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.35.6/lib/RCS/fmttime.c,v $
 *
 * DESCRIPTION:
 *
 *	Format a time string.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	August 12, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.10 $ $Date: 1994/03/30 20:32:28 $ $State: Exp $)
 * $Log: fmttime.c,v $
 * Revision 1.10  1994/03/30  20:32:28  jrroma
 * Version 3.35.6
 *
 * Revision 1.9  93/07/13  21:31:02  jrroma
 * Version 3.34
 * 
 * Revision 1.8  92/12/22  15:46:00  jrroma
 * Version 3.30
 * 
 * Revision 1.7  92/11/06  12:42:38  jrroma
 * Added support for HPUX.
 * 
 * Revision 1.6  92/06/18  13:23:47  jrroma
 * Added gnu header
 * 
 * Revision 1.5  92/06/18  09:41:40  jrroma
 * Version 3.21
 * 
 * Revision 1.4  92/05/06  10:10:34  jrroma
 * Version 3.20
 * 
 * Revision 1.3  92/02/12  16:11:22  jrroma
 * *** empty log message ***
 * 
 * Revision 1.2  92/01/16  15:42:57  jrroma
 * Added support for RS6000.
 * 
 * Revision 1.1  92/01/16  15:41:57  jrroma
 * Initial revision
 * 
 *
 */
#include <sys/types.h>			/* time_t */
#if	HPUX | SGI | SOLARIS | SYS52 | IBMRS | DECOSF
#include <time.h>
extern char *tzname [2];
extern void tzset();			/* Set local timezone */
#else
#if	BSD43 | ULTRIX
#include <sys/time.h>
extern char *timezone();
#else
BAD SYSTEM TYPE
#endif
#endif


/*** fmttime
 *
 *
 *	char *fmttime():
 *
 *	Return a pointer to a formatted time string where the time
 *	is specified as a long integer defining the number of seconds
 *	since 00:00:00 GMT, January 1, 1970.
 */
char *fmttime (timeinsecs)
time_t *timeinsecs;
{
	static char buffer [40];	/* Output buffer */
	char *tzn;			/* Time zone name */
	char *ts;			/* Time string */
	struct tm *tp;			/* Time structure pointer */

#if	HPUX | SGI | SOLARIS | SYS52 | IBMRS | DECOSF
	tzset();			/* Get local timezone */
	tp = localtime (timeinsecs);
	ts = asctime (tp);
	tzn = tzname [tp->tm_isdst];
#else
#if	BSD43 | ULTRIX
	struct	timeval	tv;
	struct	timezone tz;

	gettimeofday (&tv, &tz);
	tp = localtime (timeinsecs);
	ts = asctime (tp);
	tzn = timezone (tz.tz_minuteswest, tp->tm_isdst);
#else
BAD SYSTEM TYPE
#endif
#endif
	if (tzn == (char *) 0) tzn = "";
	ts [24] = '\0';				/* Zap newline character */
	sprintf (buffer, "%.20s%s%s", ts, tzn, ts+19);
	return (buffer);
}
