/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*       V01.20  JRR     16-Jan-1992	Added support for RS6000.
*       V01.3   JRR     28-Feb-1992	Added Cosmic V2 changes.
*	V01.4	JRR	17-Jun-1992	Added header. 
*	V01.5	JRR	06-Nov-1992 	Make system independant.
*	V01.6	JRR	18-Aug-1993	Miniscule cleanup.
*	V01.7	JRR	03-Mar-1994	Fixed up NMAP.
*/
/*++ fmtuidname.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.35.6/lib/RCS/fmtuidname.c,v $
 *
 * DESCRIPTION:
 *
 *	Return a pointer to the username of the account
 *	identified by the local user-id.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	April 29, 1986.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.7 $ $Date: 1994/03/30 20:32:29 $ $State: Exp $)
 * $Log: fmtuidname.c,v $
 * Revision 1.7  1994/03/30  20:32:29  jrroma
 * Version 3.35.6
 *
 * Revision 1.6  93/09/10  13:55:10  jrroma
 * Version 3.35
 * 
 * Revision 1.5  92/12/22  15:46:00  jrroma
 * Version 3.30
 * 
 * Revision 1.4  92/06/18  13:23:48  jrroma
 * Added gnu header
 * 
 * Revision 1.3  92/02/28  14:03:12  jrroma
 * Added Cosmic V2 changes.
 * 
 * Revision 1.2  92/01/16  15:44:24  jrroma
 * Added support for RS6000.
 * 
 * Revision 1.1  92/01/16  15:43:22  jrroma
 * Initial revision
 * 
 *
 */

#include <nqs.h>
#include "nmap.h"				/* Mid_t (all OS's) */
					/* Uid_t and gid_t (if not BSD43) */

/*** fmtuidname
 *
 *
 *	char *fmtuidname():
 *
 *	Return a pointer to the username of the account
 *	identified by the local user-id.
 */
char *fmtuidname (uid)
uid_t uid;				/* Local user-id */
{
	static char standinbuf [14];	/* Stand-in buffer */

	register char *name;		/* Pointer to name */
	register struct passwd *pw;	/* Password/account entry */

	pw = fetchpwuid ((int) uid);	/* Get account entry */
	if (pw == (struct passwd *) 0) {
		/*
		 *  No such user!  Format a "stand-in" name.
		 */
		sprintf (standinbuf, "[%1d]", (int) uid);
		name = standinbuf;
	}
	else name = pw->pw_name;
	return (name);
}
