/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*       V01.20  JRR     16-Jan-1992	Added support for RS6000.
*	V01.3	JRR	17-Jun-1992	Added header.
*	V01.4	JRR	20-Nov-1992	Modified for C prototypes.
*/
/*++ nqs_delrfs.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.30/src/RCS/nqs_delrfs.c,v $
 *
 * DESCRIPTION:
 *
 *	Delete the control and data files for the specified
 *	request.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	August 12, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.5 $ $Date: 1992/12/22 15:39:51 $ $State: Exp $)
 * $Log: nqs_delrfs.c,v $
 * Revision 1.5  1992/12/22  15:39:51  jrroma
 * Version 3.30
 *
 * Revision 1.4  92/06/18  17:30:58  jrroma
 * Added gnu header
 * 
 * Revision 1.3  92/03/02  13:36:15  jrroma
 * Added Cosmic V2 changes.
 * 
 * Revision 1.2  92/01/17  10:51:22  jrroma
 * Added support for RS6000.
 * 
 * Revision 1.1  92/01/17  10:50:26  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"			/* NQS constants and data types */
#include "nqsxdirs.h"			/* NQS global variables */


/*** void nqs_delrfs()
 *
 *
 *	void nqs_delrfs():
 *	Delete the specified control and data request files.
 */
void nqs_delrfs (orig_seqno, orig_mid, ndatafiles)
register long orig_seqno;		/* Request seq# */
register Mid_t orig_mid;		/* Request machine-id */
register short ndatafiles;		/* #of request data files */
{
	char path [MAX_PATHNAME+1];

	while (ndatafiles) {
		/*
		 *  Loop to delete data files first.
		 */
		--ndatafiles;
		pack6name (path, Nqs_data, (int) (orig_seqno % MAX_DATASUBDIRS),
			  (char *) 0, (long) orig_seqno, 5,
			  (long) orig_mid, 6, ndatafiles, 3);
		unlink (path);		/* Unlink request */
	}
	/*
	 *  Now, unlink the request control file.
	 */
	pack6name (path, Nqs_control, (int) (orig_seqno % MAX_CTRLSUBDIRS),
		  (char *) 0, (long) orig_seqno, 5, (long) orig_mid, 6, 0, 0);
	unlink (path);
        /*
         *  Now, unlink log file if it exists.
         */
        pack6name (path, Nqs_control, (int) (orig_seqno % MAX_CTRLSUBDIRS),
                  (char *) 0, (long) orig_seqno, 5, (long) orig_mid, 6, 0, 0);
        strcat (path,"l");
        unlink (path);
}
