/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.0	JRR	21-Oct-1993	Initial Version. 
*	V01.1	JRR	03-Mar-1994	Fix NMAP
*/
/*++ alterreq.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.35.6/lib/RCS/alterreq.c,v $
 *
 * DESCRIPTION:
 *
 *	Alter a non-running NQS request.
 *
 *
 *	Author:
 *	-------
 *	John Roman,  Monsanto Company
 *	October 21, 1993.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.2 $ $Date: 1994/03/30 20:32:24 $ $State: Exp $)
 * $Log: alterreq.c,v $
 * Revision 1.2  1994/03/30  20:32:24  jrroma
 * Version 3.35.6
 *
 * Revision 1.1  94/02/24  21:28:26  jrroma
 * Version 3.35.3
 * 

 * 
 *
 */

#include "nqs.h"
#include "nqspacket.h"			/* NQS local message packets */
#include "nmap.h"			/* Mid_t (all OS's) */
					/* Uid_t and gid_t (if not BSD43) */

/*** alterreq
 *
 *
 *	long alterreq():
 *
 *	Send to the NQS daemon a packet which will alter a
 *	request.
 *
 *	Returns:
 *		TCML_COMPLETE:	 if successful;
 *		TCML_NOSUCHREQ:	 if request does not exist.
 *		TCML_REQRUNNING: if the request is running.
 */
long alterreq (whomuid, req_seqno, req_mid, priority)
uid_t whomuid;			/* Calling user, else zero for */
				/* NQS operator/manager call  */
int req_seqno;			/* Request sequence number */
Mid_t req_mid;			/* Request machine id */
int priority;			/* Priority to change request to */
{
	interclear();
	interw32i ((long) whomuid);
	interw32i ((long) req_seqno);
	interw32u ((Mid_t) req_mid);
	interw32i ((long) priority);
	return (inter (PKT_ALTERREQ));
}
