/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*       V01.20  JRR     16-Jan-1992	Added support for RS6000.
*	V01.3	JRR	17-Jun-1992	Added header.
*	V01.4	JRR	07-Dec-1992	Modified for C prototypes.
*	V01.5	JRR	23-Dec-1993	Added Boeing enhancement for Mids.
*	V01.6	JRR	03-Mar-1994	Fixed up NMAP.
*/
/*++ quereqvlpq.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.35.6/lib/RCS/quereqvlpq.c,v $
 *
 * DESCRIPTION:
 *
 *	Send a "queue request in a local queue via a local
 *	pipe queue" packet to the NQS daemon.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	December 18, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.6 $ $Date: 1994/03/30 20:32:40 $ $State: Exp $)
 * $Log: quereqvlpq.c,v $
 * Revision 1.6  1994/03/30  20:32:40  jrroma
 * Version 3.35.6
 *
 * Revision 1.5  93/07/13  21:31:33  jrroma
 * Version 3.34
 * 
 * Revision 1.4  92/12/22  15:46:22  jrroma
 * Version 3.30
 * 
 * Revision 1.3  92/06/18  13:24:28  jrroma
 * Added gnu header
 * 
 * Revision 1.2  92/01/16  17:06:46  jrroma
 * Added support for RS6000.
 * 
 * Revision 1.1  92/01/16  17:06:08  jrroma
 * Initial revision
 * 
 *
 */

#include "nmap.h"			/* uid_t and mid_t */
#include "nqspacket.h"			/* NQS local message packets */

/*** quereqvlpq
 *
 *
 *	long quereqvlpq():
 *
 *	Send a "queue request in a local queue via a local
 *	pipe queue" packet to the NQS daemon.
 *
 *	Returns:
 *		TCML_COMPLETE:	 if the specified request was
 *				 successfully queued in the local
 *				 destination queue.
 *		TCML_INTERNERR:	 if maximum packet size exceeded.
 *		TCML_NOESTABLSH: if unable to establish inter-
 *				 process communication.
 *		TCML_NOLOCALDAE: if the NQS daemon is not running.
 *		TCML_NOSUCHQUE:	 if the specified destination
 *				 queue does not exist.
 *		TCML_NOSUCHREQ:	 if the specified request does not
 *				 exist.
 *		TCML_PROTOFAIL:	 if a protocol failure occurred.
 */
long quereqvlpq (orig_seqno, orig_mid, destqueue)
long orig_seqno;			/* Original sequence# */
Mid_t orig_mid;				/* Original machine-id of req */
char *destqueue;			/* Name of local queue where */
{					/* request should be queued */
	interclear();
	interw32i ((long) orig_seqno);
	interw32u (orig_mid);
	interwstr (destqueue);
	return (inter (PKT_QUEREQVLPQ));
}
