/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*++ destacct.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs-3.21/lib/RCS/destacct.c,v $
 *
 * DESCRIPTION:
 *
 *	Return a pointer to the account-name portion of a remote
 *	account specification:  account@machine_name.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	November 5, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.2 $ $Date: 92/06/18 13:23:39 $ $State: Exp $)
 * $Log:	destacct.c,v $
 * Revision 1.2  92/06/18  13:23:39  jrroma
 * Added gnu header
 * 
 * Revision 1.1  92/06/18  09:53:14  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"			/* NQS types and definitions */

/*** destacct
 *
 *
 *	char *destacct():
 *
 *	Return a pointer to the account-name portion of a remote
 *	account specification:  account@machine_name.
 */
char *destacct (remote_account)
register char *remote_account;		/* Remote account specification text */
{
	static char acctname [MAX_ACCOUNTNAME+2];
					/* Remote account name of one */
					/* extra byte so that caller can */
					/* tell if the account name is too */
					/* long. */
	register char *copyto;		/* Copyto pointer */
	register unsigned size;		/* Copy size */

	size = 0;			/* Nothing copied yet */
	copyto = acctname;		/* Where to copy */
	while (*remote_account && *remote_account != '@' &&
	       size < MAX_ACCOUNTNAME+1) {
		*copyto++ = *remote_account++;
		size++;			/* One more character copied */
	}				/* specification */
	*copyto = '\0';			/* Null terminate */
	return (acctname);		/* Return pointer to account name */
}
