/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*++ rewritedb.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.30/lib/RCS/rewritedb.c,v $
 *
 * DESCRIPTION:
 *
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	August 12, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.3 $ $Date: 1992/12/22 15:46:25 $ $State: Exp $)
 * $Log: rewritedb.c,v $
 * Revision 1.3  1992/12/22  15:46:25  jrroma
 * Version 3.30
 *
 * Revision 1.2  92/06/18  13:24:34  jrroma
 * Added gnu header
 * 
 * Revision 1.1  92/06/18  12:46:41  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"
#include <errno.h>
#include <unistd.h>

/*** rewritedb
 *
 *
 *	void rewritedb():
 *
 *	Rewrite an existing gendescr structure in the specified file
 *	at the specified offset position.  The file position is left
 *	pointing at the descriptor that was just re-written.
 */
void rewritedb (file, position, descr, descrtype)
register struct confd *file;		/* Configuration file */
long position;				/* File offset position */
struct gendescr *descr;			/* New version of descriptor */
int descrtype;				/* Descriptor type */
{
	register struct gendescr *target;

	seekdbb (file, position);
	/*
	 *  Rewrite the descriptor contents.
	 */
	target = (struct gendescr *) (file->cache->v.chars
	       + position % ATOMICBLKSIZ);
	bytecopy ((char *) &target->v, (char *) &descr->v,
		  sizedb (descr, descrtype));
	/*
	 *  Seek for write().
	 */
	lseek (file->fd, file->rposition - ATOMICBLKSIZ, 0);
	errno = 0;			/* Set to zero so partial writes do */
					/* not show spurious error message */
					/* text in nqs_abort(). */
	if (write (file->fd, file->cache->v.chars,
		   ATOMICBLKSIZ) != ATOMICBLKSIZ) {
		printf ("F$Write error in rewritedb().\n");
		nqs_abort();
	}
}
