/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*       V01.2   JRR     28-Feb-1992	Added Cosmic V2 changes.
*       V01.3   JRR     20-Mar-1992	Added suspend / resume codes..
*       V01.4   JRR     07-Apr-1992     Added CERN fixes.
*	V01.5	JRR	17-Jun-1992	Added header.
*	V01.6	JRR	20-Nov-1992	A couple of new messages.
*/
/*++ tcmident.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.30/lib/RCS/tcmident.c,v $
 *
 * DESCRIPTION:
 *
 *
 *	Return a character string pointer to the identifier
 *	associated with a specific transaction reason code.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	May 22, 1986.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.6 $ $Date: 1992/12/22 15:46:35 $ $State: Exp $)
 * $Log: tcmident.c,v $
 * Revision 1.6  1992/12/22  15:46:35  jrroma
 * Version 3.30
 *
 * Revision 1.5  92/06/18  13:24:55  jrroma
 * Added gnu header
 * 
 * Revision 1.4  92/05/06  10:20:38  jrroma
 * Version 3.20
 * 
 * Revision 1.3  92/04/07  12:53:15  jrroma
 * *** empty log message ***
 * 
 * Revision 1.2  92/02/28  15:38:42  jrroma
 * Added Cosmic V2 changes.
 * 
 * Revision 1.1  92/02/28  15:36:33  jrroma
 * Initial revision
 * 
 *
 */

#include "informcc.h"		/* NQS information completion codes */
#include "transactcc.h"		/* NQS transaction completion codes */
#include <string.h>

#define	LOCAL_ORIGIN	001	/* Code can originate locally */
#define	PEER_ORIGIN	002	/* Code can originate at peer */



/*** tcmident
 *
 *
 *	char *tcmident():
 *
 *	Return a character string pointer to the identifier
 *	associated with a specific transaction reason code.
 */
char *tcmident (code)
register long code;			/* Completion code */
{
	static char identbuffer [32];	/* Identifier name buffer for return */
	static struct {
		char *generic_name;	/* Generic name of transaction code */
		short origin;		/* Possibilities of origin */
	} identifiers [] = {
		{ "ACCESSDEN",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "ALREADACC",	LOCAL_ORIGIN			},
		{ "ALREADEXI",	LOCAL_ORIGIN			},
		{ "BADCDTFIL",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "CLIMIDUNKN",			PEER_ORIGIN	},
		{ "COMPLETE",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "CONNBROKEN",			PEER_ORIGIN	},
		{ "CONNTIMOUT",			PEER_ORIGIN	},
		{ "CONTINUE",			PEER_ORIGIN	},
		{ "CPUALRESVD",	LOCAL_ORIGIN			},
		{ "DEVACTIVE",	LOCAL_ORIGIN			},
		{ "DEVENABLE",	LOCAL_ORIGIN			},
		{ "EACCESS",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "EFBIG",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "EISDIR",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "ELOOP",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "ENFILE",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "ENOBUFS",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "ENOENT",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "ENOMEM",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "ENOSPC",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "ENOTDIR",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "ENXIO",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "EPERM",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "EPIPE",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "EROFS",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "ERRORRETRY",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "ETIMEDOUT",	LOCAL_ORIGIN			},
		{ "ETXTBSY",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "FATALABORT",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "FIXBYNQS",	LOCAL_ORIGIN			},
		{ "GRANFATHER",	LOCAL_ORIGIN			},
		{ "INSHUTDOWN",	LOCAL_ORIGIN			},
		{ "INSQUESPA",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "INSUFFMEM",	LOCAL_ORIGIN			},
		{ "INSUFFPRV",	LOCAL_ORIGIN			},
		{ "INTERNERR",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "LOGFILERR",	LOCAL_ORIGIN			},
		{ "MAXNETCONN",			PEER_ORIGIN	},
		{ "MAXQDESTS",	LOCAL_ORIGIN			},
		{ "MIDCONFLCT",			PEER_ORIGIN	},
		{ "NETDBERR",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "NETNOTSUPP",	LOCAL_ORIGIN			},
		{ "NETPASSWD",			PEER_ORIGIN	},
		{ "NOACCAUTH",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "NOACCNOW",	LOCAL_ORIGIN			},
		{ "NOESTABLSH",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "NOLOCALDAE",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "NOMOREPROC",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "NONETDAE",			PEER_ORIGIN	},
		{ "NONSECPORT",			PEER_ORIGIN	},
		{ "NOPORTAVAI",	LOCAL_ORIGIN			},
		{ "NOSUCHACC",	LOCAL_ORIGIN			},
		{ "NOSUCHCPU",	LOCAL_ORIGIN			},
		{ "NOSUCHDES",	LOCAL_ORIGIN			},
		{ "NOSUCHDEV",	LOCAL_ORIGIN			},
		{ "NOSUCHFORM",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "NOSUCHGRP",	LOCAL_ORIGIN			},
		{ "NOSUCHMAC",	LOCAL_ORIGIN			},
		{ "NOSUCHMAN",	LOCAL_ORIGIN			},
		{ "NOSUCHMAP",	LOCAL_ORIGIN			},
		{ "NOSUCHQUE",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "NOSUCHQUO",	LOCAL_ORIGIN			},
		{ "NOSUCHREQ",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "NOSUCHSIG",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "NOTREQOWN",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "PATHLEN",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "PEERARRIVE",	LOCAL_ORIGIN			},
		{ "PEERDEPART",	LOCAL_ORIGIN			},
		{ "PLOCKFAIL",	LOCAL_ORIGIN			},
		{ "PROTOFAIL",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "QUEDISABL",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "QUEENABLE",	LOCAL_ORIGIN			},
		{ "QUEHASREQ",	LOCAL_ORIGIN			},
		{ "QUOTALIMIT",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "REQCOLLIDE",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "REQDELETE",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "REQRUNNING",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "REQSIGNAL",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "ROOTINDEL",	LOCAL_ORIGIN			},
		{ "RRFUNKNMID",			PEER_ORIGIN	},
		{ "SELMIDUNKN",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "SELREFDES",	LOCAL_ORIGIN			},
		{ "SHUTERROR",	LOCAL_ORIGIN			},
		{ "SUBMITTED",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "TOOMANDEV",	LOCAL_ORIGIN			},
		{ "UNAFAILURE",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "UNDEFINED",	LOCAL_ORIGIN |	PEER_ORIGIN	},
		{ "UNRESTR",	LOCAL_ORIGIN			},
		{ "WROQUETYP",	LOCAL_ORIGIN |	PEER_ORIGIN	},
                { "NOSUCHCOM",  LOCAL_ORIGIN                    },
                { "TOOMANQUE",  LOCAL_ORIGIN                    },
                { "TOOMANCOM",  LOCAL_ORIGIN                    },
                { "ALREADCOM",  LOCAL_ORIGIN                    },
                { "NOTMEMCOM",  LOCAL_ORIGIN                    },
                { "REQRESUMED", LOCAL_ORIGIN | PEER_ORIGIN      },
                { "REQSUSPENDED",  LOCAL_ORIGIN | PEER_ORIGIN   },
                { "REQWASRUNNING",  LOCAL_ORIGIN | PEER_ORIGIN  },
                { "REQWASSUSPENDED",  LOCAL_ORIGIN | PEER_ORIGIN},
		{ "QUEBUSY",    LOCAL_ORIGIN | PEER_ORIGIN      },
		{ "NOMOREMEM",  LOCAL_ORIGIN                    },
		{ "REQNOTHELD", LOCAL_ORIGIN                    },
		{ "INVLDLBFLAGS", LOCAL_ORIGIN                  },
		{ "DAEALRUN", LOCAL_ORIGIN                      },
		{ "DAENOTRUN", LOCAL_ORIGIN                     }
		
	};

	register short reason;		/* Reason bits of completion code */

	reason = (code & (XCI_REASON_MASK & ~XCI_PEER_MASK));
	if (reason > (TCM_MAXTCM & (XCI_REASON_MASK & ~XCI_PEER_MASK)) ||
	   !(code & XCI_TRANSA_MASK)) {
		/*
		 *  The transaction code is invalid.
		 */
		reason = (TCML_UNDEFINED & XCI_REASON_MASK);
	}
	if (reason & XCI_PEER_MASK) {
		/*
		 *  The transaction code originated at a transaction
		 *  peer.
		 */
		strcpy (identbuffer, "TCMP_");
		if (identifiers [reason].origin & PEER_ORIGIN) {
			strcat (identbuffer, identifiers[reason].generic_name);
		}
		else strcat (identbuffer, "badpeercod");
	}
	else {	/* The transaction code originated at the local host */
		strcpy (identbuffer, "TCML_");
		if (identifiers [reason].origin & LOCAL_ORIGIN) {
			strcat (identbuffer, identifiers[reason].generic_name);
		}
		else strcat (identbuffer, "badlocalcd");
	}
	return (identbuffer);
}
