/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*       V01.2   JRR     03-Mar-1992	Added Cosmic V2 changes.
*	V01.3	JRR	17-Jun-1992	Added header.
*	V01.4	JRR	11-Nov-1992	Added support for HPUX.
*					(by removing dependancy on SGI0\).
*/
/*++ shlexefai.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.35.6/src/RCS/shlexefai.c,v $
 *
 * DESCRIPTION:
 *
 *	Inform the shepherd process of a shell process created to
 *	execute an NQS batch request, that the execve() system
 *	call to invoke the actual shell failed.
 *
 *	This program MUST run as setuid to root program, in order
 *	to signal the NQS shepherd process running as root.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	January 22, 1986.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.5 $ $Date: 1994/03/30 20:37:13 $ $State: Exp $)
 * $Log: shlexefai.c,v $
 * Revision 1.5  1994/03/30  20:37:13  jrroma
 * Version 3.35.6
 *
 * Revision 1.4  92/12/22  15:43:28  jrroma
 * Version 3.30
 * 
 * Revision 1.3  92/06/18  17:31:37  jrroma
 * Added gnu header
 * 
 * Revision 1.2  92/03/03  14:03:44  jrroma
 * Added Cosmic V2 changes.
 * 
 * Revision 1.1  92/03/03  14:02:41  jrroma
 * Initial revision
 * 
 *
 */

#include <signal.h>
#include <stdlib.h>

/*** main
 *
 *
 *	Invocation from a failed shell execve() call is as follows:
 *
 *	  $(NQS_LIBEXE)/shlexefai <ASCII-errno-code>
 *
 */
main (argc, argv)
int argc;
char *argv[];
{
	int parent_pid;			/* Process-id of NQS shepherd */

	parent_pid = getppid();
	if (parent_pid > 1) {
		/*
		 *  The NQS shepherd process for this failed shell
		 *  process has not exited.
		 */
		kill (parent_pid, SIGPIPE);
					/* Send a SIGPIPE signal to the */
					/* NQS shepherd process */
	}
	_exit (atoi (argv [1]));	/* Exit */
}
