\"
\"	Network Queueing System (NQS)
\"  This version of NQS is Copyright (C) 1992  John Roman
\"
\"  This program is free software; you can redistribute it and/or modify
\"  it under the terms of the GNU General Public License as published by
\"  the Free Software Foundation; either version 1, or (at your option)
\"  any later version.
\"
\"  This program is distributed in the hope that it will be useful,
\"  but WITHOUT ANY WARRANTY; without even the implied warranty of
\"  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
\"  GNU General Public License for more details.
\"
\"  You should have received a copy of the GNU General Public License
\"  along with this program; if not, write to the Free Software
\"  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\"
\"	NQS INSTALLATION DOCUMENT
\"	nroff -mm -Tlp thisfile > thatfile
\"	-Tlp gets rid of escape sequences (e.g. for ".sp .5")
.de iS		\" Start display
.sp 1
.in +.5i
.nf
..
.de iE		\" End display
.in -.5i
.fi
.sp .5
..
.nr H1 1	\" EDIT H1, H2, and H3 for the VDD.
.nr H2 1
.nr H3 0
\"	What to replace \*(hS with
.ds hS 1.1.1
.nr Hs 6	\" Expand .H with following blank line if nesting <= 6 
.PH "''PRELIMINARY DRAFT'\n(mo/\n(dy/\n(yr'"	\" TAKE THESE 2 LINES
.PF "''PRELIMINARY DRAFT'%'"			\" OUT FOR VDD
\"	End of set up
.H 3 "Installation of NQS"
.H 4 "Background"
.P
The Network Queueing System (\f2NQS\fP) is designed for portability.
Installing it on a new system usually requires nothing
more than selecting the appropriate makefile, making
the executables, making the directories, installing the
executables, and installing the man pages.  The source
code itself is the same from system to system.
.P
This is information on the Monsanto implementation of NQS.
.P
This version of NQS has makefiles for the following architectures:
.iS
Architecture	Operating System	Makefile
Sun		SUNOS 4.1		Makefile.sun
HP		HPUX 8.0.7		Makefile.hpux
SGI		IRIX 4.0.5		Makefile.sgi
IBM RS6000	AIX 3.2			Makefile.ibm
DEC MIPs	Ultrix 4.1		Makefile.ultrix
.iE
.sp
If you wish to port NQS to another architecture, you will
need to take one of these makefiles and modify it appropriately.
.P
What follows is an explanation of how to make and install NQS
and some information on how to modify NQS. 
.P
.IR "IF YOU WISH TO TUNE NQS" ,
it is essential that you read proto/Makefile and h/nqs.h.
They describe all compile-time tunable parameters.
See
.I qmgr(1M)
for a description of run-time tunable parameters.
.H 4 "Noteworthy Inter-Dependencies with Other Software or Hardware"
.P
NQS uses a quartet of disk inodes to keep
track of a request as it passes from state to state.
At the time of making directories, NQS reserves all the inodes
it needs, and keeps them in a private pool.  These inodes come
from the disk partition where NQS does its spooling, typically 
/usr/spool/nqs.
.P
.I "INSTALLATION MIGHT FAIL"
if NQS tries to reserve more inodes
than are available on the disk partition in question.
Use
.I df(1M)
to verify that enough inodes are available
on that partition before invoking make.
Be sure to take into account any inodes that will be freed
when the present copy of NQS is expunged.
Here is an approximate count of the inodes required:
.iS
SUN	 800 inodes	(supports 200 requests)
SGI	 800 inodes	(supports 200 requests)
HP	 800 inodes	(supports 200 requests)
IBM	2000 inodes	(supports 500 requests)
Ultrix	 800 inodes	(supports 200 requests)
.iE
.sp
You may edit h/nqs.h to raise or lower the number of inodes NQS
will grab.
See the appropriate makefile in the proto subdirectory 
for more information and a warning.
.P	
.H 4 "Files"
.H 5 "Source Files"
.P
The following files represent all of NQS.  For all but the
man pages, the names are given
relative to the directory
.IR "nqs".
If your system has an
old copy of NQS source, you may find a few file names in the old
source for which there is no identically named file in the new
source.  In all such cases, the old file is no longer needed,
and need not be present to make the new NQS.
.iS
\&./h/informcc.h
\&./h/mkreqcc.h
\&./h/netpacket.h
\&./h/netvars.h
\&./h/netxvars.h
\&./h/nqs.h
\&./h/nqs_proto.h
\&./h/nqsacct.h
\&./h/nqsdeflim.h
\&./h/nqsdirs.h
\&./h/nqsmail.h
\&./h/nqsmgr.h
\&./h/nqspacket.h
\&./h/nqsstruct.h
\&./h/nqsvars.h
\&./h/nqsxdirs.h
\&./h/nqsxvars.h
\&./h/quolim.h
\&./h/requestcc.h
\&./h/scpnqs.h
\&./h/transactcc.h

\&./help/qmgr.hlp

\&./lib/a6btoul.c
\&./lib/allodb.c
\&./lib/analyzercm.c
\&./lib/analyzetcm.c
\&./lib/asciierrno.c
\&./lib/blockdb.c
\&./lib/bufstderr.c
\&./lib/bufstdout.c
\&./lib/bytecopy.c
\&./lib/bytezero.c
\&./lib/closedb.c
\&./lib/daepres.c
\&./lib/delreq.c
\&./lib/destacct.c
\&./lib/destdev.c
\&./lib/destpath.c
\&./lib/destqueue.c
\&./lib/errnototcm.c
\&./lib/establish.c
\&./lib/fetchgrdb.c
\&./lib/fetchpwdb.c
\&./lib/filecopy.c
\&./lib/fmtgidname.c
\&./lib/fmtmidname.c
\&./lib/fmttime.c
\&./lib/fmtuidname.c
\&./lib/fopendata.c
\&./lib/freedb.c
\&./lib/fsizedb.c
\&./lib/gethdr.c
\&./lib/getreq.c
\&./lib/getrreq.c
\&./lib/getsockch.c
\&./lib/getwdir.c
\&./lib/grpnam.c
\&./lib/hdlreq.c
\&./lib/inter.c
\&./lib/interread.c
\&./lib/interwrite.c
\&./lib/isdecstr.c
\&./lib/ldbalsrv.c
\&./lib/ldparam.c
\&./lib/list_nqs_queues.c
\&./lib/listnet.c
\&./lib/listq.c
\&./lib/listr.c
\&./lib/localmid.c
\&./lib/machacct.c
\&./lib/machpath.c
\&./lib/machspec.c
\&./lib/macnam.c
\&./lib/main_dsp.c
\&./lib/mapuser.c
\&./lib/match.c
\&./lib/mergertcm.c
\&./lib/mkdefault.c
\&./lib/mkreq.c
\&./lib/movreq.c
\&./lib/namstderr.c
\&./lib/namstdlog.c
\&./lib/namstdout.c
\&./lib/nextdb.c
\&./lib/nextseqno.c
\&./lib/nqspriv.c
\&./lib/nqssleep.c
\&./lib/opendata.c
\&./lib/opendb.c
\&./lib/openqacc.c
\&./lib/openqord.c
\&./lib/pack6name.c
\&./lib/parseserv.c
\&./lib/pipeqdest.c
\&./lib/pipeqdiag.c
\&./lib/pipeqreq.c
\&./lib/qdel_by_req.c
\&./lib/quereqvlpq.c
\&./lib/quolimok.c
\&./lib/rcimsgs.c
\&./lib/rcmmsgs.c
\&./lib/readdb.c
\&./lib/readhdr.c
\&./lib/readreq.c
\&./lib/reqspec.c
\&./lib/rewritedb.c
\&./lib/scancpulim.c
\&./lib/scanquolim.c
\&./lib/scantime.c
\&./lib/secgrfir.c
\&./lib/seekdb.c
\&./lib/seekdbb.c
\&./lib/serexit.c
\&./lib/setmtime.c
\&./lib/setpeertcm.c
\&./lib/shoalldev.c
\&./lib/shoalllim.c
\&./lib/shoallque.c
\&./lib/shodbydesc.c
\&./lib/shodbyname.c
\&./lib/sholbymach.c
\&./lib/shoqbydesc.c
\&./lib/shoqbyname.c
\&./lib/showcomplex.c
\&./lib/sizedb.c
\&./lib/suspendreq.c
\&./lib/tcimsgs.c
\&./lib/tcmident.c
\&./lib/tcmmsgs.c
\&./lib/telldb.c
\&./lib/transact.c
\&./lib/usenam.c
\&./lib/verifyhdr.c
\&./lib/verifyreq.c
\&./lib/writehdr.c
\&./lib/writereq.c

\&./libndir/README
\&./libndir/closedir.c
\&./libndir/dir.4.2.h
\&./libndir/directory.3s
\&./libndir/opendir.c
\&./libndir/readdir.c
\&./libndir/seekdir.c
\&./libndir/telldir.c

\&./man/nqs.1
\&./man/nqsconfig.1
\&./man/nqsgs.1
\&./man/nqsrn.1
\&./man/qacct.1
\&./man/qcat.1
\&./man/qcmplx.1
\&./man/qdel.1
\&./man/qdev.1
\&./man/qhold.1
\&./man/qjob.1
\&./man/qlimit.1
\&./man/qmgr.1m
\&./man/qpr.1
\&./man/qresume.1
\&./man/qrls.1
\&./man/qstat.1
\&./man/qstatc.1
\&./man/qsub.1
\&./man/qsuspend.1

\&./npsn_compat/README
\&./npsn_compat/ioblksiz.h
\&./npsn_compat/nmap.h
\&./npsn_compat/nmap_proto.h
\&./npsn_compat/nmapcommon.c
\&./npsn_compat/nmapcommon.h
\&./npsn_compat/nmapmgr.c
\&./npsn_compat/nmapread.c
\&./npsn_compat/nmapwrite.c

\&./proto/Makefile.hpux
\&./proto/Makefile.ibm
\&./proto/Makefile.ibm.test
\&./proto/Makefile.nodev
\&./proto/Makefile.sgi
\&./proto/Makefile.sgi.test
\&./proto/Makefile.sun
\&./proto/Makefile.ultrix
\&./proto/make_include
\&./proto/make_include_nodev

\&./src/loaddaemon.c
\&./src/logdaemon.c
\&./src/lpserver.c
\&./src/mgr_adsset.c
\&./src/mgr_cmd.c
\&./src/mgr_main.c
\&./src/mgr_memdump.c
\&./src/mgr_movset.c
\&./src/mgr_mssgs.c
\&./src/mgr_packet.c
\&./src/mgr_scan.c
\&./src/mgr_show.c
\&./src/mgr_snap.c
\&./src/netclient.c
\&./src/netdaemon.c
\&./src/netserver.c
\&./src/nqs_a2s.c
\&./src/nqs_aboque.c
\&./src/nqs_abort.c
\&./src/nqs_boot.c
\&./src/nqs_broadcast.c
\&./src/nqs_bsc.c
\&./src/nqs_complt.c
\&./src/nqs_delreq.c
\&./src/nqs_delrfs.c
\&./src/nqs_deque.c
\&./src/nqs_disreq.c
\&./src/nqs_dsc.c
\&./src/nqs_enf.c
\&./src/nqs_enfile.c
\&./src/nqs_failed.c
\&./src/nqs_family.c
\&./src/nqs_fndnnq.c
\&./src/nqs_fndreq.c
\&./src/nqs_ldconf.c
\&./src/nqs_load.c
\&./src/nqs_mai.c
\&./src/nqs_main.c
\&./src/nqs_memdump.c
\&./src/nqs_modreq.c
\&./src/nqs_nsq.c
\&./src/nqs_pip.c
\&./src/nqs_psc.c
\&./src/nqs_quereq.c
\&./src/nqs_rbuild.c
\&./src/nqs_reqcom.c
\&./src/nqs_reqexi.c
\&./src/nqs_reqser.c
\&./src/nqs_spawn.c
\&./src/nqs_suspendreq.c
\&./src/nqs_tid.c
\&./src/nqs_udb.c
\&./src/nqs_upc.c
\&./src/nqs_upd.c
\&./src/nqs_upf.c
\&./src/nqs_upm.c
\&./src/nqs_upp.c
\&./src/nqs_upq.c
\&./src/nqs_ups.c
\&./src/nqs_upv.c
\&./src/nqs_vtimer.c
\&./src/nqs_wakdes.c
\&./src/nqs_wakreq.c
\&./src/pipeclient.c
\&./src/qacct.c
\&./src/qcat.c
\&./src/qcmplx.c
\&./src/qdel.c
\&./src/qdev.c
\&./src/qhold.c
\&./src/qjob.c
\&./src/qlimit.c
\&./src/qmsg.c
\&./src/qpr.c
\&./src/qrls.c
\&./src/qstat.c
\&./src/qstatc.c
\&./src/qsub.c
\&./src/qsuspend.c
\&./src/shlexefai.c

\&./utility/nqsmgrhelp.c
\&./utility/nqsmkdirs.c
\&./utility/nqsmktrans.c
.iE
.H 5 "Target Files"
Although the location of these files can be changed, here is the
default locations:
.iS
/usr/lib/nqs/loaddaemon
/usr/lib/nqs/logdaemon
/usr/lib/nqs/lpserver
/usr/lib/nqs/netclient
/usr/lib/nqs/netdaemon
/usr/lib/nqs/netserver
/usr/lib/nqs/nqsdaemon
/usr/lib/nqs/pipeclient
/usr/lib/nqs/qmgr.hlp
/usr/lib/nqs/shlexefai
/usr/lib/nqs/sitename
/usr/bin/qacct
/usr/bin/qcat
/usr/bin/qdel
/usr/bin/qdev
/usr/bin/qhold
/usr/bin/qjob
/usr/bin/qlimit
/usr/bin/qmgr
/usr/bin/qpr
/usr/bin/qrls
/usr/bin/qstat
/usr/bin/qstatc
/usr/bin/qsub
/usr/bin/qsuspend
/usr/bin/nmapmgr
.iE
.H 5 "Other Files"
.iS
/etc/rc			(see Administration Issues, \*(hS.4.5)
.iE
.H 4 "Installation Instructions"
.H 5 "Source Files"
.P
The source files should be present as described above.
.H 5 "Header Files"
.P
NQS does not contribute any header files to the system at large.
Therefore, it is not necessary to install any header files.
.P
One header file, nqsmgrhelp.h, is not supplied with the source
code.
.IR "THIS IS INTENTIONAL" .
Nqsmgrhelp.h is generated in
the course of making mgr_main.o.
.P
The NQS makefile records the dependence of NQS executables
upon system wide header files.  In some cases, the absolute
path name of a system-wide header file might differ from
system to system.  If that is the case on your system,
edit the appropriate NQS makefile.
.P
The NQS make process distinguishes between the different
operating systems indicated above.
.H 5 "Library Files"
.P
NQS does not contribute any libraries to the system at large.
Therefore, it is not necessary to install any libraries.
NQS private libraries are made in the same step that makes
the NQS executables below.
.H 5 "Executable Files"
.P
If NQS is already running on your system,
.I "BE CERTAIN THAT YOU SHUTDOWN"
NQS before installing (see
.IR qmgr(1M) ).
The NQS makefile (proto/Makefile)
installs into the running system.
.P
.BR "make -f Makefile.xxx install" ,
where xxx is the appropriate suffix and
executed with uid = 0 in the proto
directory will make and install
the NQS executables. 
.P
.BR "make -f Makefile.xxx directories" ,
where xxx is the appropriate suffix and
executed with uid = 0 in the
.I proto
directory, will make the NQS directories.
.H 5 "Administration Issues"
.P
There are four daemon processes associated with NQS.
.iS
the local daemon
the log daemon
the net daemon
the load daemon
.iE
.P
Two lines in the appropriate system startup file
will fire up all three daemons.
Those lines are:
.iS
.B
echo Network Queueing System starting
/usr/lib/nqs/nqsdaemon > /dev/null
.R
.P
After the daemons are running, qmgr should
be invoked to provide configuration information that could
not be compiled in.  On your system, there may be a set-up
script, for example
.IR "setup.qmgr" .
If there is, you may start by typing
.BR "qmgr < setup.qmgr" .
If not (which is more likely),
you may use the following to get started.  Invoke qmgr as root.
.iS	
.B
show all
add managers yourself:m
.iE
.iS
create batch_queue bqname priority = 16
set default batch_request queue bqname
.iE
.sp
.R
The following are optional.
.iS
.B
set forms fname
create device dname forms = fname fullname = /dev/somewhere \e
	server = (server command line goes here)
enable device dname
create device_queue dqname priority = 16 device = dname
.iE
.sp
.iS
.B
create pipe_queue todest priority = 16 \e
	server = (/usr/lib/nqs/pipeclient) destination = bqname@machine
.iE
.R
.P
Lastly, when you are ready for customers,
.iS
.B
enable queue bqname
start queue bqname
.iE
.sp
.R
The following are only necessary if you created these above.
.iS
.B
enable queue dqname
start queue dqname
enable queue todest
start queue todest
.iE
.sp
.R
.H 5 "Manual Entries"
.P
There are seven man pages.  They are listed in the Source Files section
(\*(hS.3.1) above.  The installation procedures vary according to system.
.H 6 "SGI IRIS"
.P
The man pages are in somewhere/usr/src/man/u_man/man1 and
somewhere/usr/src/man/a_man/man1.  Installation should be done in
the same step that is performed to install all man pages.
.H 6 "VAX System V"
.P
The man pages are in somewhere/usr/src/man/u_man/man1 and
somewhere/usr/src/man/a_man/man1.
You must check that
somewhere/usr/src/man/u_man/man1/Makefile and
somewhere/usr/src/man/a_man/man1/Makefile cause the correct man pages
to be installed.
.H 6 "UNICOS"
The man pages are in somewhere/usr/src/man/u_man/man1 and
somewhere/usr/src/man/a_man/man1.  Installation should be done in
the same step that is performed to install all man pages.
The UNICOS installed man page directory structure is non-standard.
Beware.
.P
.H 6 "UTS"
.P
The man pages are in somewhere/usr/src/man/u_man/man1 and
somewhere/usr/src/man/a_man/man1.  Installation should be done in
the same step that is performed to install all man pages.
.H 5 "Test Procedures"
.P
The following is a quick test to see if NQS was installed
correctly.  Recall that the daemons
must be fired up first (see Administration Issues, \*(hS.4.5).
.P
From a shell, verify that /usr/bin (the location of qdel, etc)
is in your path. Rehash if necessary.
.P	
Type
.BR "qstat -x" .
The qstat command should be found, should
show whatever queues you configured in the Administration Issues
section, and should exit.
.P
Go to your home directory.
.P
Type
.BR "qsub<cr>" .
Type
.BR "date<cr>" .
Type
.BR "^d" .
Qsub should report that a batch request was submitted.
Within a few seconds, stderr and stdout files should
appear in your current directory.  Stderr should be
empty (unless your .profile and/or .cshrc + .login
file execute commands which are not appropriate in
a batch environment),
and stdout should contain the output of date.

