/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*++ nqs_wakdes.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.30/src/RCS/nqs_wakdes.c,v $
 *
 * DESCRIPTION:
 *
 *	Re-enable pipe queue destinations that are presently in retry
 *	mode, whose retry wait time has elapsed.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	May 30, 1986.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.3 $ $Date: 1992/12/22 15:41:41 $ $State: Exp $)
 * $Log: nqs_wakdes.c,v $
 * Revision 1.3  1992/12/22  15:41:41  jrroma
 * Version 3.30
 *
 * Revision 1.2  92/06/18  17:31:34  jrroma
 * Added gnu header
 * 
 * Revision 1.1  92/06/18  15:00:33  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"
#include "nqsxvars.h"			/* Global vars and directories */
#include <time.h>

/*** nqs_wakdes
 *
 *
 *	void nqs_wakdes():
 *
 *	Re-enable pipe queue destinations that are presently in retry
 *	mode, whose retry wait time has elapsed.
 */
void nqs_wakdes()
{
	struct pipeto *dest;	/* Pipe queue destination */
	time_t timenow;			/* Current GMT time */

	time (&timenow);		/* Get current time */
	dest = Pipetoset;		/* Global pipe queue destination set */
	while (dest != (struct pipeto *) 0) {
	    if (dest->status == DEST_RETRY) {
		/*
		 *  This destination is in the retry state, and
		 *  has NOT been re-enabled.
		 */
		if (dest->retry_at > timenow) {
		    /*
		     *  Set alarm for destination retry in
		     *  the future.
		     */
		    nqs_vtimer (&dest->retry_at, nqs_wakdes);
		} else {
		    /*
		     *  This destination must be enabled
		     *  (leaving the retry bit set)!
		     */
		    dest->status |= DEST_ENABLED;
	            udb_destination (dest);	/* Update database */
		}
	    }
	    dest = dest->next;	/* Examine next destination */
	}
	/*
	 *  Maybe spawn some pipe queue requests, and update and
	 *  pipe queue request-ordering files that need to be
	 *  modified.
	 */
	psc_spawn();			/* Maybe spawn some pipe requests */
}
