/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10	JRR	16-Jan-1992	Add support for RS6000.
*	V01.2	JRR	17-Jun-1992	Added header.
*	V01.3	JRR	05-Nov-1992	Added support for HPUX.
*	V01.4	JRR	06-Apr-1993	Added support for DECOSF.
*	V01.5	JRR			Placeholder
*	V01.6	JRR	28-Feb-1994	Added support for SOLARIS.
*/
/*++ daepres.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.35.6/lib/RCS/daepres.c,v $
 *
 * DESCRIPTION:
 *
 *	Determine if the local NQS daemon is present.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	October 3, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.6 $ $Date: 1994/03/30 20:32:26 $ $State: Exp $)
 * $Log: daepres.c,v $
 * Revision 1.6  1994/03/30  20:32:26  jrroma
 * Version 3.35.6
 *
 * Revision 1.5  93/07/13  21:30:59  jrroma
 * Version 3.34
 * 
 * Revision 1.4  92/11/06  11:00:03  jrroma
 * Added support for HPUX.
 * 
 * Revision 1.3  92/06/18  13:23:38  jrroma
 * Added gnu header
 * 
 * Revision 1.2  92/01/16  15:16:02  jrroma
 * Added support for RS6000.
 * 
 * Revision 1.1  92/01/16  15:14:16  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"			/* NQS definitions */
#if	BSD43 | ULTRIX | DECOSF
#include <sys/file.h>
#else
#if	SGI | SOLARIS | HPUX | SYS52 | IBMRS | LINUX
#include "nqspacket.h"			/* NQS local message packets */
#else
BAD SYSTEM TYPE
#endif
#endif
#include "transactcc.h"			/* TCMx_ codes */


/*** daepres
 *
 *
 *	int daepres():
 *	Determine if the local NQS daemon is present.
 *
 *	Returns:
 *		1: if the local NQS daemon IS present.
 *		0: if the local NQS daemon is NOT present.
 */
#if	BSD43 | ULTRIX | DECOSF
int daepres (struct confd *runfile) 	/* Locked exclusively if the NQS */
					/* daemon is running just fine; */
					/* Unlocked if NQS is not running, */
					/* or is shutting down */
{
	if (flock (runfile->fd, LOCK_SH | LOCK_NB) == -1) {
		/*
		 *  The local NQS daemon has the queues file locked
		 *  exclusively with an advisory lock, and is therefore
		 *  running.
		 */
		return (1);		/* Local NQS daemon is running */
	}
	/*
	 *  We were able to successfully apply a shared advisory lock to
	 *  the queues file.  Therefore, the local NQS daemon is either
	 *  shutdown, or in the process of shutting down.
	 *
	 *  Before we return, we must give up the shared advisory lock,
	 *  so that a future incarnation of the resurrected NQS daemon, can
	 *  successfully apply an advisory exclusive lock on the queues
	 *  file.
	 */
	flock (runfile->fd, LOCK_UN);	/* Release the lock */
	return (0);			/* Local NQS daemon is not running */
}
#else
#if	SGI | SOLARIS | HPUX | SYS52 | IBMRS | LINUX
int daepres ()
{
	interclear();
	if (inter (PKT_SENSEDAEMON) == TCML_COMPLETE) return (1);
	return (0);			/* The NQS daemon is not running */
}
#else
BAD SYSTEM TYPE
#endif
#endif
