/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*       V01.20  JRR     16-Jan-1992	Added support for RS6000.
*       V01.3   JRR     28-Feb-1992	Added Cosmic V2 changes.
*	V01.4	JRR	17-Jun-1992	Added header.
*	V01.5	JRR	05-Nov-1992	Added support for HPUX.
*	V01.6	JRR	06-Apr-1993	Added support for DECOSF.
*	V01.7	JRR	12-Aug-1993	Removed non-networked code.
*	V01.8	JRR	28-Feb-1994	Added support for SOLARIS.
*/
/*++ errnototcm.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.35.6/lib/RCS/errnototcm.c,v $
 *
 * DESCRIPTION:
 *
 *
 *	Convert a file access related errno code to its corresponding
 *	transaction code.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	April 27, 1986.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.8 $ $Date: 1994/03/30 20:32:26 $ $State: Exp $)
 * $Log: errnototcm.c,v $
 * Revision 1.8  1994/03/30  20:32:26  jrroma
 * Version 3.35.6
 *
 * Revision 1.7  93/09/10  13:55:09  jrroma
 * Version 3.35
 * 
 * Revision 1.6  93/07/13  21:31:00  jrroma
 * Version 3.34
 * 
 * Revision 1.5  92/11/06  11:10:09  jrroma
 * Added support for HPUX.
 * 
 * Revision 1.4  92/06/18  13:23:42  jrroma
 * Added gnu header
 * 
 * Revision 1.3  92/02/28  13:51:44  jrroma
 * Added Cosmic V2 changes.
 * 
 * Revision 1.2  92/01/16  15:32:58  jrroma
 * Added support for RS6000.
 * 
 * Revision 1.1  92/01/16  15:31:56  jrroma
 * Initial revision
 * 
 *
 */

#include <errno.h>		/* Errno definitions */
#include "transactcc.h"		/* NQS transaction completion codes */


/*** errnototcm
 *
 *
 *	long errnototcm():
 *	Convert errno code to transaction completion code.
 *
 *	Returns:
 *		The transaction code corresponding to the
 *		errno condition.
 */
long errnototcm ()
{
	switch (errno) {
	case EACCES:
		return (TCML_EACCESS);
	case EFBIG:
		return (TCML_EFBIG);
	case EISDIR:
		return (TCML_EISDIR);
#if	BSD43 | ULTRIX | DECOSF 
	case ELOOP:
		return (TCML_ELOOP);
#else
#if	HPUX | SGI | SOLARIS | SYS53 | IBMRS | LINUX
#else
BAD SYSTEM TYPE
#endif
#endif
	case ENFILE:
		return (TCML_ENFILE);
	case ENOBUFS:
		return (TCML_ENOBUFS);
	case ENOENT:
		return (TCML_ENOENT);
	case ENOMEM:
		return (TCML_ENOMEM);
	case ENOSPC:
		return (TCML_ENOSPC);
	case ENOTDIR:
		return (TCML_ENOTDIR);
	case ENXIO:
		return (TCML_ENXIO);
	case EPERM:
		return (TCML_EPERM);
	case EPIPE:
		return (TCML_EPIPE);
	case EROFS:
		return (TCML_EROFS);
	case ETIMEDOUT:
		return (TCML_ETIMEDOUT);
	case ETXTBSY:
		return (TCML_ETXTBSY);
	}
	return (TCML_FATALABORT);
}
