/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*       V01.20  JRR     16-Jan-1992	Added support for RS6000.
*       V01.3   JRR     03-Mar-1992	Added Cosmic V2 changes.
*	V01.4	JRR	17-Jun-1992	Added header.
*	V01.5	JRR	03-Sep-1992	Added support for remote limits.
*	V01.6	JRR	08-Mar-1993	Added Boeing enhancement for files.
*	V01.7	JRR	18-Apr-1993	Fixed up usage message.
*/
/*++ qlimit.c - Network Deviceing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.35/src/RCS/qlimit.c,v $
 *
 * DESCRIPTION:
 *
 *	Display  
 *	1) a list of the meaningful limits and
 *	2) the current shell strategy
 *	for the named machines.
 *	This program must run as a setuid root program.
 *
 * RETURNS:
 *
 *      0       -  if output produced
 *      1       -  if an error occurred. A message is sent to the standard
 *                      output file for every error.
 *
 *
 *	Author:
 *	-------
 *	Robert W. Sandstrom, Sterling Software Incorporated.
 *	January 13, 1986.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.7 $ $Date: 1993/09/10 13:57:28 $ $State: Exp $)
 * $Log: qlimit.c,v $
 * Revision 1.7  1993/09/10  13:57:28  jrroma
 * Version 3.35
 *
 * Revision 1.6  93/07/13  21:34:10  jrroma
 * Version 3.34
 * 
 * Revision 1.5  92/12/22  15:43:23  jrroma
 * Version 3.30
 * 
 * Revision 1.4  92/06/17  08:45:37  jrroma
 * Version 3.21
 * 
 * Revision 1.3  92/03/03  13:43:37  jrroma
 * Added Cosmic V2 changes.
 * 
 * Revision 1.2  92/01/17  11:25:40  jrroma
 * Added support for RS6000.
 * 
 * Revision 1.1  92/01/17  11:25:07  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"
#include "nqsdirs.h"			/* NQS files and directories */

#ifndef __CEXTRACT__
#if __STDC__

static void sho_version ( void );
static void showhow ( void );

#else /* __STDC__ */

static void sho_version (/* void */);
static void showhow (/* void */);
#endif /* __STDC__ */
#endif /* __CEXTRACT__ */

/*
 *	Global variables:
 */
char *Qlimit_prefix = "Qlimit";

/*** main
 *
 *
 *	qlimit [ <machine-name(s)> ]
 */
main (int argc, char *argv[])
{
	struct confd *paramfile;
	char *argument;
        int exitcode = 0;                       /* Function exit code */
	char *root_dir;                 /* Fully qualified file name */

	if ( ! buildenv()) {
	    fprintf (stderr, "%s(FATAL): Unable to ", Qlimit_prefix);
	    fprintf (stderr, "establish directory independent environment.\n");
	    exit (1);
	}
	root_dir = getfilnam (Nqs_root, SPOOLDIR);
	if (root_dir == (char *)NULL) {
	    fprintf (stderr, "%s(FATAL): Unable to ", Qlimit_prefix);
	    fprintf (stderr, "determine root directory name.\n");
	    exit (1);
	}
	if (chdir (root_dir) == -1) {
	    fprintf (stderr, "%s(FATAL): Unable to chdir() to the NQS ",
                 Qlimit_prefix);
	    fprintf (stderr, "root directory.\n");
	    relfilnam (root_dir);
	    exit (1);
	}
	relfilnam (root_dir);
	if ((paramfile = opendb (Nqs_params, O_RDONLY)) == NULL) {
	    fprintf (stderr, "%s(FATAL): Unable to open the NQS ",
			 Qlimit_prefix);
	    fprintf (stderr, "parameters database file.\n");
	    exit (1);
	}
	while (*++argv != NULL && **argv == '-') {
	    argument = *argv;
	    while (*++argument != '\0') {
	        switch (*argument) {
                case 'v':
                    sho_version();
		    exit(1);
                    break;
		default:
		    fprintf (stderr, "Invalid option flag specified.\n");
		    showhow();
		    exit (1);
		}
	    }
	}
	
	/*
	 *  Block buffer stdout for efficiency.
	 */
	bufstdout();
        if (*argv == NULL)  exitcode |= shoalllim (paramfile, SHO_SHS);
	else {
	    while (*argv != NULL) {		/* Show info on a machine */
                exitcode |= sholbymach (paramfile, *argv, SHO_SHS);
		argv++;
	    }
	}
	/*
	 *  Flush output buffers and exit.
	 */
	fflush (stdout);
	fflush (stderr);
	exit (exitcode);
}
static void sho_version()
{
     fprintf(stderr, "NQS version is %s\n", NQS_VERSION);
}
static void showhow()
{
fprintf (stderr, "qlimit -- print NQS limits\n");
fprintf (stderr, "usage:    qlimit [-v] [hostname]\n");
fprintf (stderr, "-v        print version information\n");
fprintf (stderr, "hostname  name of host if not current host\n");
    exit (0);
}
