/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*++ nqs_enfile.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.35/src/RCS/nqs_enfile.c,v $
 *
 * DESCRIPTION:
 *
 *	Determine if the last file open error operation was caused
 *	by a lack of file descriptors, and if so--display the proper
 *	error output.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	August 12, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.3 $ $Date: 1993/09/10 13:57:13 $ $State: Exp $)
 * $Log: nqs_enfile.c,v $
 * Revision 1.3  1993/09/10  13:57:13  jrroma
 * Version 3.35
 *
 * Revision 1.2  92/06/18  17:31:03  jrroma
 * Added gnu header
 * 
 * Revision 1.1  92/06/18  14:59:52  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"
#include <errno.h>
#include "nqsxvars.h"			/* Global vars */

extern int errno;			/* Error number */

/*** nqs_enfile
 *
 *
 *	int nqs_enfile():
 *	Diagnose a shortage of file descriptors.
 *
 *	Returns:
 *		0: if errno is NOT either EMFILE or ENFILE.
 *		1: if errno is either EMFILE or ENFILE in which
 *		   case error output is generated.
 */
int nqs_enfile ()
{
	if (errno == ENFILE || errno == EMFILE) {
		if (errno == ENFILE) {
			printf ("E$Unable to open file.\n");
			printf ("I$System file table full.\n");
			fflush (stdout);
			return (1);
		}
		printf ("F$Unable to open file.\n");
		printf ("I$Max open files per-process limit reached.\n");
		fflush (stdout);
		return (1);
	}
  	else
  	{
    	 	printf ("F$Unknown filing failure.\n");
	  	printf ("I$Error code %d : %s\n", errno, strerror(errno));
		fflush (stdout);
	}
	return (0);		/* Nope, not ENFILE or EMFILE. */
}
