/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*       V01.20  JRR     16-Jan-1992	Added support for RS6000.
*	V01.30	JRR	17-Jan-1992	Fixed reference to dir.4.2 for RS6000.
*	V01.40	JRR	20-Jan-1992	Fixed reference to dirent for RS6000.
*	V01.5	JRR	17-Jun-1992	Added header.  
*	V01.6	JRR	10-Nov-1992	Added support for HPUX.
* 	V01.7	JRR	06-Apr-1993	Added support for DECOSF.
*	V01.8	JRR	28-Feb-1994	Added support for SOLARIS.
*/
/*++ nqs_failed.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.35.6/src/RCS/nqs_failed.c,v $
 *
 * DESCRIPTION:
 *
 *	Move the named request control file to the NQS hold directory
 *	for failed requests.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	August 12, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.8 $ $Date: 1994/03/30 20:36:35 $ $State: Exp $)
 * $Log: nqs_failed.c,v $
 * Revision 1.8  1994/03/30  20:36:35  jrroma
 * Version 3.35.6
 *
 * Revision 1.7  93/07/13  21:33:49  jrroma
 * Version 3.34
 * 
 * Revision 1.6  92/12/22  15:39:54  jrroma
 * Version 3.30
 * 
 * Revision 1.5  92/06/18  17:31:03  jrroma
 * Added gnu header
 * 
 * Revision 1.4  92/01/20  14:38:24  jrroma
 * Fixed up reference to dirent for RS6000.
 * 
 * Revision 1.3  92/01/17  11:32:26  jrroma
 * Fixed reference to dir.4.2.h for RS6000.
 * 
 * Revision 1.2  92/01/17  10:54:59  jrroma
 * Added support for RS6000.
 * 
 * Revision 1.1  92/01/17  10:52:56  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"			/* MAX_PATHNAME definition */
#include <string.h>
#include "nqsxvars.h"			/* Global vars and directories */
#if	SYS52 
#include "dir.4.2.h"			/* Include directory walking defs */
#else
#if	SGI | BSD43 | ULTRIX | DECOSF | IBMRS
#include <sys/dir.h>			/* Include directory walking defs */
#else
#if	HPUX
#include <ndir.h>
#else
#if     SOLARIS | LINUX
#include <dirent.h>
#else
BAD SYSTEM TYPE
#endif
#endif
#endif
#endif

/*** nqs_failed
 *
 *
 *	void nqs_failed():
 *
 *	Move the named request control file from the control directory
 *	to the holding directory for failed requests.
 */
void nqs_failed (long orig_seqno, Mid_t orig_mid)
{
	char ctrlname [15];		/* Name of control file in control */
					/* directory */
	char path [MAX_PATHNAME+1];	/* Control/data subdirectory path */
	char datapath [MAX_PATHNAME+1];	/* Data subdirectory path */
	char holdpath [MAX_PATHNAME+1];	/* Failed directory path */
	DIR *dir;			/* Open queue order dir structure */
#if	IBMRS | DECOSF | SOLARIS | LINUX | ULTRIX
	struct dirent *dirent;		/* Ptr to directory entry */
#else
	struct direct *dirent;		/* Ptr to directory entry */
#endif

	printf ("I$Request being placed in failed directory.\n");
	fflush (stdout);
	pack6name (path, Nqs_control, (int) (orig_seqno % MAX_CTRLSUBDIRS),
		  (char *) 0, (long) orig_seqno, 5, (long) orig_mid, 6, 0, 0);
	pack6name (ctrlname, (char *) 0, -1, (char *) 0, (long) orig_seqno, 5,
		  (long) orig_mid, 6, 0, 0);
	sprintf (holdpath, "%s/%s", Nqs_failed, ctrlname);
	link (path, holdpath);		/* Establish link in failed dir */
	unlink (path);			/* Remove control subdirectory entry */
	/*
	 *  Traverse the appropriate data subdirectory to grab all data
	 *  files associated with the failed request.
	 */
	pack6name (datapath, Nqs_data, (int) (orig_seqno % MAX_DATASUBDIRS),
		  (char *) 0, 0L, 0, 0L, 0, 0, 0);
	if ((dir = opendir (datapath)) == (DIR *) 0) {
		printf ("E$Unable to open the data dir. in nqs_failed().\n");
		printf ("I$Data files for failed request ");
		printf ("not moved to failed directory.\n");
		fflush (stdout);
		return;
	}
#if	IBMRS | DECOSF | SOLARIS | LINUX | ULTRIX
	while ((dirent = readdir (dir)) != (struct dirent *) 0) {
#else
	while ((dirent = readdir (dir)) != (struct direct *) 0) {
#endif
		/*
		 *  Determine if this data file is for the request being
		 *  placed on hold.
		 */
		if (strlen (dirent->d_name) == 14 &&
		    is6bitstr (dirent->d_name, 14) &&
		    strncmp (dirent->d_name, ctrlname, 11) == 0) {
			/*
			 *  This data file is for the request being placed
			 *  in the failed directory.
			 */
			sprintf (path, "%s/%s", datapath, dirent->d_name);
			sprintf (holdpath, "%s/%s", Nqs_failed,
				 dirent->d_name);
			link (path, holdpath);	/*Establish link to data file*/
			unlink (path);		/*Remove from data dir */
		}
	}
	closedir (dir);			/* Close the data file directory */
}
