/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*       V01.20  JRR     12-Feb-1992	Fixed up call to static routine.
*	V01.3	JRR	17-Jun-1992	Added header.
*	V01.4	JRR	07-Dec-1992	Modified for C prototypes.
*/
/*++ nqssleep.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.30/lib/RCS/nqssleep.c,v $
 *
 * DESCRIPTION:
 *
 *	NQS version of sleep().  The System V one has a very nasty
 *	bug such that when a non-SIGALRM signal arrives which is to
 *	be caught, AND the SIGALRM signal just happens to arrive
 *	while handling the first signal, then we never return to
 *	the original signal handler.
 *
 *	Thank you again AT&T.  The mighty mountain has labored, and
 *	once again failed to even produce a mouse correctly.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	August 12, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.4 $ $Date: 1992/12/22 15:46:18 $ $State: Exp $)
 * $Log: nqssleep.c,v $
 * Revision 1.4  1992/12/22  15:46:18  jrroma
 * Version 3.30
 *
 * Revision 1.3  92/06/18  13:24:19  jrroma
 * Added gnu header
 * 
 * Revision 1.2  92/02/12  11:02:51  jrroma
 * Fixed static routine call.
 * 
 * Revision 1.1  92/02/12  10:54:09  jrroma
 * Initial revision
 * 
 *
 */

#include <signal.h>

static void alarmsig ( int );

/*
 *
 *
 *	Variables local to this module.
 */
static short alarm_semaphore;		/* SIGALRM semaphore */


/*** nqssleep
 *
 *
 *	nqssleep():
 *	Sleep for N seconds.
 */
void nqssleep (int timetosleep)
{
	void (*sigalrm_sav)();		/* Save old SIGALRM handler */
	unsigned origalarm;		/* Original alarm time */

	origalarm = alarm (0);		/* Get original alarm set */
	sigalrm_sav = signal (SIGALRM, alarmsig); /* Get/Set SIGALRM handler */
	alarm_semaphore = 0;		/* Clear SIGALRM semaphore */
	alarm (timetosleep);		/* Set the alarm */
	while (alarm_semaphore == 0) pause();
	signal (SIGALRM, sigalrm_sav);	/* Restore SIGALRM state */
	alarm (origalarm);		/* Restore the original alarm */
}


/*** alarmsig
 *
 *
 *	void alarmsig():
 *
 *	This function serves as the signal catcher for SIGARLM signals
 *	occuring as the result of an alarm () call in the return_file()
 *	function above.
 *
 *	This function SETS the "alarm_semphore" flag.
 */
static void alarmsig ( int unused )
{
	signal (SIGALRM, alarmsig);
	alarm_semaphore++;		/* SIGALRM received */
}
