#ifndef __CATALOGUE_MESSAGE_HEADER
#define __CATALOGUE_MESSAGE_HEADER

/*
 * message.h
 * Message catalogue support
 */

/*
 * Author(s)
 *
 * Stuart Herbert (SLH)
 * Academic Computing Services
 * University of Sheffield
 * Email : S.Herbert@Sheffield.ac.uk
 */

/* ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** *****
 * Modifications
 *
 *	1.00	SLH	07 Apr 95	Initial version
 * 	1.01	SLH	12 Jul 95	Moved from UFC into CATALOGUE,
 * 					for use with SETUP v2.
 */

#include <stdio.h>

/* ***** ***** ***** *****
 * Supported Languages
 *
 * Add new languages here - ensure that UFCD_LANG_MAX has the highest
 * value of all the #defines.
 */

#define UFCD_LANG_ENGUK		0
#define UFCD_LANG_ENGUS		1
#define UFCD_LANG_MAX		2

/* ***** *****
 * Message types
 */

typedef unsigned int UFCT_Message;
typedef unsigned int UFCT_Language;

/* ***** *****
 * Message table
 */

struct TAG_UFCT_MessageTable
{
  char *szMessage;
    /* the message string */
};

typedef struct TAG_UFCT_MessageTable UFCT_MessageTable;
typedef struct TAG_UFCT_MessageTable UFCT_LanguagesTable;

/* ***** *****
 * Language table
 */

struct TAG_UFCT_LanguageTable
{
  UFCT_Language		 ulLanguage;
    /* id string for the language - one of UFCD_LANG_* */
  UFCT_MessageTable	*stMessageTable;
    /* pointer to the first message for that language */
  unsigned long		 ulNoOfMessages;
    /* number of messages in the catalogue */
};

typedef struct TAG_UFCT_LanguageTable UFCT_LanguageTable;

/* ***** *****
 * Message API
 */

extern unsigned int UFCF_GetLanguageNo(char *);
extern char * UFCF_GetMessage(UFCT_LanguageTable *, UFCT_Message);
extern void UFCF_SetLanguage (UFCT_Language);

#endif // __CATALOGUE_MESSAGE_HEADER
