/*
 * nqs_generic/BSD/bytecopy.c
 * Copy n bytes around the place.
 */

#include <nqs_generic/license.h>
  /* NQS license information */
#include <nqs_generic/debug.h>
  /* debugging support */

/*** bytecopy
 *
 *	bytecopy():
 *	Copy exactly N bytes.
 */
void bytecopy (char *to, char *from, int n)
{
  ENTER_FUNCTION("nqs_generic/BSD/bytecopy");
  
  TEST_ARG(to   != NULL, 1);
  TEST_ARG(from != NULL, 2);
  TEST_ARG(n    >  0,    3);
  
  bcopy(from, to, n);
  
  EXIT_FUNCTION;
}
