/*
 * nqs-generic/all-systems/tcimsgs.c
 * Output TCI code meanings
 */

#include <nqs_generic/license.h>
  /* NQS license information */
#include <nqs_generic/debug.h>
  /* debugging support */
#include <nqs_generic/proto.h>
  /* ANSI C prototype support */

#include <stdio.h>
  /* FILE definition */
#include <nqs_generic/TCI.h>
  /* NQS information completion codes */
#include <nqs_generic/tblmsgs.h>
  /* NQS table message handling facility */

static msg_table stTCImsgs [] =
{
  { TCI_COPLIMEXC,	NULL,	"  Copy limit;\n"					},
  { TCI_PP_CFLEXC,	NULL,	"  Per-process core-file size limit;\n"			},
  { TCI_PP_CTLEXC,	NULL,	"  Per-process CPU time limit;\n"			},
  { TCI_PP_DSLEXC,	NULL,	"  Per-process data-segment limit;\n"			},
  { TCI_PP_MSLEXC,	NULL,	"  Per-process memory size limit;\n"			},
  { TCI_PP_NELEXC,	NULL,	"  Per-process nice execution priority limit;\n"	},
  { TCI_PP_PFLEXC,	NULL,	"  Per-process permanent file size limit;\n"		},
  { TCI_PP_QFLEXC,	NULL,	"  Per-process quick file size quota limit;\n"		},
  { TCI_PP_SSLEXC,	NULL,	"  Per-process stack-segment limit;\n"			},
  { TCI_PP_TFLEXC,	NULL,	"  Per-process temporary file size limit;\n"		},
  { TCI_PP_WSLEXC,	NULL,	"  Per-process working set quota limit;\n"		},
  { TCI_PRILIMEXC,	NULL,	"  Print/output size limit;\n"				},
  { TCI_PR_CTLEXC,	NULL,	"  Per-request CPU time limit;\n"			},
  { TCI_PR_DRIEXC,	NULL,	"  Per-request tape drive quota limit;\n"		},
  { TCI_PR_MSLEXC,	NULL,	"  Per-request memory space limit;\n"			},
  { TCI_PR_NCPEXC,	NULL,	"  Per-request CPU quota limit;\n"			},
  { TCI_PR_PFLEXC,	NULL,	"  Per-request permanent file space limit;\n"		},
  { TCI_PR_QFLEXC,	NULL,	"  Per-request quick file space quota limit;\n"		},
  { TCI_PR_TFLEXC,	NULL,	"  Per-request temporary file space limit;\n"		},
  { 0,			NULL,	NULL							}
};


/*** tcimsgs
 *
 *	void tcimsgs():
 *	Diagnose transaction code information bits.
 */
void tcimsgs (
	long code,				/* Completion code */
	FILE *stream,				/* Output stream */
	char *prefix,				/* Output prefix */
	void (*headerfn)(FILE *, char *))	/* Header display function */
{
  ENTER_FUNCTION("nqs_generic/all-systems/tcimsgs");
  TEST_ARG(stream   != NULL, 2);
  TEST_ARG(prefix   != NULL, 3);
  TEST_ARG(headerfn != NULL, 4);
  
  tblmsgs(code, stream, prefix, headerfn, &stTCImsgs[0]);
  
  EXIT_FUNCTION;
}
