/*
 * nqs_generic/all-systems/get_timezone.c
 * Obtain timezone information
 */

#include <nqs_generic/license.h>
  /* NQS license information */
#include <nqs_generic/debug.h>
  /* debugging support */
#include <nqs_generic/proto.h>
  /* ANSI C prototype support */

#include <time.h>
#include <stdio.h>

short get_timezone (void)
{
  time_t timeinsecs;		/* Time in seconds from 0:00:00 */
				/* January 1, 1970-GMT */
  /*
   *  Get the current time/date and local timezone for later use.
   */
  
  struct timeval  tv;
  struct timezone tz;

  ENTER_FUNCTION("nqs_generic/BSD/get_timezone");
  
  time (&timeinsecs);			/* Get current time */
  gettimeofday (&tv, &tz);		/* Get timezone information */
  local_zone = tz.tz_minuteswest;	/* Timezone in minutes west from GMT */
  
  EXIT_FUNCTION;
  return local_zone;
}
