/*
 * nqs_generic/all-systems/bufstdout.c
 * Set the buffer size on the stdout stream.
 */

#include <nqs_generic/license.h>
  /* NQS license information */
#include <nqs_generic/debug.h>
  /* debugging support */
#include <nqs_generic/proto.h>
  /* ANSI C prototypes */

#include <stdio.h>

/*** bufstdout
 *
 *	void bufstdout():
 *	Block buffer the output to the stdout file stream.
 */
void bufstdout (void)
{
  static char szStdout_buffer [BUFSIZ];	/* Stdout output buffer */

  ENTER_FUNCTION("nqs_generic/all-systems/bufstdout");

  setvbuf (stdout, szStdout_buffer, _IOFBF, BUFSIZ);
  EXIT_FUNCTION;
}
