/*
 * nqs_generic/all-systems/usenam.c
 * Obtain the user's username
 */

#include <nqs_generic/license.h>
  /* NQS license information */
#include <nqs_generic/debug.h>
  /* debugging support */
#include <nqs_generic/proto.h>
  /* ANSI C prototype support */

#include <malloc.h>
#include <string.h>
#include <nqs_db/nqs_db.h>

/*** getusenam
 *
 *	char *getusenam():
 *
 *	Return the username for the specified user-id on the local
 *	machine.
 */
char *getusenam (uid_t uid)
{
  struct passwd *pstPasswd;
    /* structure to hold password entry */
  
  ENTER_FUNCTION("nqs_generic/all-systems/getusenam");
    /* debugging information */
  
  if ((pstPasswd = fetchpwuid(uid)) == NULL)
  {
    DEBUGGING(INFO, DEBUG_LOW, "Unable to find any record of user %d\n", uid);
    EXIT_FUNCTION;
    return NULL;
  }
  else
  {
    EXIT_FUNCTION;
    return pstPasswd->pw_name;
  }
  NEVER;
}

/*** endusenam
 *
 *
 *	void endusenam():
 *	Clear the user-id/name cache.
 */
void endusenam (void)
{
  ENTER_FUNCTION("nqs-generic/all-systems/endusenam");
  
  DEBUGGING(INFO, DEBUG_HIGH, "endusenam called\n");
  EXIT_FUNCTION;
}
