#ifndef __NQS_GENERIC_RCI_HEADER
#define __NQS_GENERIC_RCI_HEADER

/*
 * nqs_generic/RCI.h
 * Request completion information
 * 
 * See ChangeLog for modification list
 */

#include <nqs_generic/license.h>

/*
 * NOTES:
 * 
 * 	1) The RCI_ values used here are used only within the local machine
 * 	   and so it is safe to change their value if necessary.
 */

/*
 *	This file describes the information flags that are valid
 *	for the 21-bits of information data in an NQS completion
 *	code.
 *
 *	All NQS request and transaction completion codes fit in
 *	a long integer.  Each NQS completion code is broken down
 *	into four (4) sections:
 *
 *	.----------------------------------------------------------.
 *	| 0 | 21-bits of additional information | T | 9-bit reason |
 *	`----------------------------------------------------------'
 *
 *	The highest-order bit must be zero, to make the value positive,
 *	for "32-bit machines."
 *
 *	The 'T' bit when set, indicates that the code is a TRANSACTION
 *	completion code.  Otherwise, the code is a REQUEST completion
 *	code.
 */

#define	RCI_ACCESSDEN	000000002000L
  /* Access denied */
#define RCI_CLIMIDUNKN	000000004000L
  /* Client mid unknown at peer */
#define	RCI_EFBIG	000000010000L
  /* File size limit exceeded */
#define	RCI_FATALABORT	000000020000L
  /* Fatal transaction error */
#define	RCI_MIDCONFLICT	000000040000L
  /* Client/dest machine-id conflict */
#define	RCI_NETNOTSUPP	000000100000L
  /* Networking not supported */
#define	RCI_NETPASSWD	000000200000L
  /* Net password verification error */
#define	RCI_NOSUCHFORM	000000400000L
  /* No such device forms */
#define	RCI_NOSUCHQUE	000001000000L
  /* No such queue */
#define	RCI_PEERINTERR	000002000000L
  /* Local NQS internal error at peer */
#define	RCI_PEERMIDUNKN	000004000000L
  /* Local machine-id unknown at peer */
#define	RCI_PEERNETDB	000010000000L
  /* Network database error at peer */
#define	RCI_PEERNOACATH	000020000000L
  /* No account authorization at peer */
#define	RCI_PROTOFAIL	000040000000L
  /* NQS protocol failure */
#define	RCI_QUOTALIMIT	000100000000L
  /* Quota limits exceed maximums */
#define RCI_RRFUNKNMID	000200000000L
  /* Request refers to unknown mid */
#define	RCI_WROQUETYP	000400000000L
  /* Wrong queue type for request */
#define	RCI_UNAFAILURE	001000000000L
  /* Unanticipated failure */

#endif 		/* __NQS_GENERIC_RCI_HEADER */