#ifndef __NQS_QUEUE_QUE_HEADER
#define __NQS_QUEUE_QUE_HEADER

/*
 * nqs_queue/all-systems/QUE.h
 * Queue status flags for Monsanto-NQS
 */

#include <nqs_generic/license.h>

/*
 *	Queue status flags.
 */
#define	QUE_RUNNING	0000001		/* Queue is running */
					/* Otherwise queue is stopped */
#define	QUE_ENABLED	0000002		/* Queue is enabled to receive new */
					/* requests.  Otherwise queue is */
					/* closed to new requests. */
#define	QUE_NETRETRY	0000004		/* Network queue while technically */
					/* in the retry state, is waiting */
					/* to make a retry attempt in the */
					/* future */
#define QUE_LDB_OUT     0000010         /* Queue is to be load balanced outbound */
                                        /* (Round robin the destination queues) */
#define QUE_LDB_IN      0000020         /* Queue is to be load balanced inbound */
                                        /* (Refuse requests if no initiators) */
#define	QUE_UPDATE	0100000		/* The queue image in the NQS data- */
					/* base needs to be updated for */
					/* this queue. */
#define	QUE_PIPEONLY	0040000		/* Reqs may only be added to this */
					/* queue from another pipe queue. */
#define QUE_BYGIDUID	0020000		/* Access restricted by gid, uid */


/*
 *	Queue type flags.
 */
#define	QUE_BATCH	1		/* Queue is for batch requests */
#define	QUE_DEVICE	2		/* Queue is for device requests */
#define	QUE_NET		3		/* Queue is a network machine queue */
#define	QUE_PIPE	4		/* Queue is a pipe queue */

#endif /* __NQS_QUEUE_QUE_HEADER */
