/*
 * nqs_generic/all-systems/errnototcm.c
 * Convert file IO error numbers into TCM codes
 */

#include <nqs_generic/license.h>
  /* NQS license information */
#include <nqs_generic/debug.h>
  /* debugging support */
#include <errno.h>
  /* Errno definitions */
#include <nqs_req/TCM.h>
  /* NQS transaction completion codes */

/*** errnototcm
 *
 *
 *	long errnototcm():
 *	Convert errno code to transaction completion code.
 *
 *	Returns:
 *		The transaction code corresponding to the
 *		errno condition.
 */
long errnototcm (void)
{
  long ulTcmCode;
    /* holds the TCM code to return */
  
  ENTER_FUNCTION("nqs_generic/all-systems/errnototcm");
  
  switch (errno)
  {
   case EACCES:
    ulTcmCode = TCML_EACCESS;
    break;
   case EFBIG:
    ulTcmCode = TCML_EFBIG;
    break;
   case EISDIR:
    ulTcmCode = TCML_EISDIR;
    break;
   case ENFILE:
    ulTcmCode = TCML_ENFILE;
    break;
   case ENOBUFS:
    ulTcmCode = TCML_ENOBUFS;
    break;
   case ENOENT:
    ulTcmCode = TCML_ENOENT;
    break;
   case ENOMEM:
    ulTcmCode = TCML_ENOMEM;
    break;
   case ENOSPC:
    ulTcmCode = TCML_ENOSPC;
    break;
   case ENOTDIR:
    ulTcmCode = TCML_ENOTDIR;
    break;
   case ENXIO:
    ulTcmCode = TCML_ENXIO;
    break;
   case EPERM:
    ulTcmCode = TCML_EPERM;
    break;
   case EPIPE:
    ulTcmCode = TCML_EPIPE;
    break;
   case EROFS:
    ulTcmCode = TCML_EROFS;
    break;
   case ETIMEDOUT:
    ulTcmCode = TCML_ETIMEDOUT;
    break;
   case ETXTBSY:
    ulTcmCode = TCML_ETXTBSY;
    break;
   default:
    ulTcmCode = TCML_FATALABORT;
  }
  EXIT_FUNCTION;
  return ulTcmCode;
}
