/*
 * nqs_generic/all-systems/fmtuidname.c
 * Format a user ID value in a string.
 */

#include <nqs_generic/license.h>
  /* NQS license information */
#include <nqs_generic/debug.h>
  /* debugging information */

#include <nqs_db/nqs_db.h>
  /* prototype for fetchpwuid() */

/*** fmtuidname
 *
 *	char *fmtuidname():
 *
 *	Return a pointer to the username of the account
 *	identified by the local user-id.
 */
char *fmtuidname (uid_t uid)
{
  static char szStandinbuf [17];
    /* Stand-in buffer */

  char *szName;
    /* Pointer to name */
  struct passwd *pstPw;
    /* Password/account entry */

  ENTER_FUNCTION("nqs_generic/all-systems/fmtuidname");
    /* debugging info */
  
  pstPw = fetchpwuid (uid);
    /* Get account entry */
  
  if (pstPw == NULL)
  {
    /*
     *  No such user!  Format a "stand-in" name.
     */
    
    sprintf (szStandinbuf, "[%1d]", (int) uid);
    szName = szStandinbuf;
  }
  else
    szName = pstPw->pw_name;
  
  EXIT_FUNCTION;
  return (szName);
}
